package bigbank.web.ui;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.osoa.sca.ModuleContext;
import org.osoa.sca.ModuleContextFactoryLocator;

import services.account.AccountService;
import services.profile.LoginService;

public class LoginServlet extends HttpServlet{

	private ServletContext mContext;

	public void init(ServletConfig pCfg) throws ServletException{
		mContext = pCfg.getServletContext();
	}

	public void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException{
		
		LoginService loginMgr = (LoginService)
			ModuleContextFactoryLocator.getModuleContextFactory().
			getModuleContext().locateService("LoginServiceComponent"); 
		
		if (loginMgr == null){
			throw new ServletException("LoginManager not found");
		}

		String login = pReq.getParameter("login");
		String password = pReq.getParameter("password");
		try{
			if (login == null || password == null){
				pResp.sendRedirect("summary.jsp");
			}
			int resp = loginMgr.login(login, password);
			if (resp == LoginService.SUCCESS){
				pResp.sendRedirect("summary.jsp");
			}else{
				mContext.getRequestDispatcher("/login.jsp").forward(pReq, pResp);
			}
		}catch (IOException e){
			throw new ServletException(e);
		}
	}
}
