/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.DefaultScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAObject;

public class ModelFileIndex
implements IResourceProxyVisitor {
    private static final IResourceDescriptor[] NO_DESCRIPTORS = new IResourceDescriptor[0];
    private static final SCAObject[] NO_MODELS = new SCAObject[0];
    private final Set composites = new HashSet();
    private final Set componentTypes = new HashSet();
    private final Set modules = new HashSet();
    private final Set subsystems = new HashSet();
    private final IProject project;
    private IEditModelScribbler scribbler;

    public ModelFileIndex(IProject theProject) {
        this.project = theProject;
        try {
            this.project.accept((IResourceProxyVisitor)this, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addModelFile(IFile file) {
        if ("composite".equals(file.getFileExtension())) {
            this.composites.add(file);
        }
        if ("componentType".equals(file.getFileExtension())) {
            this.componentTypes.add(file);
        }
        if ("module".equals(file.getFileExtension())) {
            this.modules.add(file);
        }
        if ("subsystem".equals(file.getFileExtension())) {
            this.subsystems.add(file);
        }
    }

    public synchronized SCAObject[] getModelObjects() {
        if (this.getScribbler() == null) {
            return NO_MODELS;
        }
        HashSet<SCAObject> models = new HashSet<SCAObject>();
        IFile file2 = null;
        SCACoreRoot root = null;
        Resource resource = null;
        for (IFile file2 : this.composites) {
            resource = this.scribbler.getResource(file2.getFullPath());
            if (resource.getContents().size() <= 0 || (root = (SCACoreRoot)resource.getContents().get(0)).getComposite() == null) continue;
            models.add(root.getComposite());
        }
        for (IFile file2 : this.componentTypes) {
            resource = this.scribbler.getResource(file2.getFullPath());
            if (resource.getContents().size() <= 0 || (root = (SCACoreRoot)resource.getContents().get(0)).getComponentType() == null) continue;
            models.add(root.getComponentType());
        }
        for (IFile file2 : this.modules) {
            resource = this.scribbler.getResource(file2.getFullPath());
            if (resource.getContents().size() <= 0 || (root = (SCACoreRoot)resource.getContents().get(0)).getModule() == null) continue;
            models.add(root.getModule());
        }
        for (IFile file2 : this.subsystems) {
            resource = this.scribbler.getResource(file2.getFullPath());
            if (resource.getContents().size() <= 0 || (root = (SCACoreRoot)resource.getContents().get(0)).getSubsystem() == null) continue;
            models.add(root.getSubsystem());
        }
        return models.toArray(new SCAObject[models.size()]);
    }

    public IProject getProject() {
        return this.project;
    }

    protected IEditModelScribbler getScribbler() {
        if (this.scribbler == null) {
            try {
                this.scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(this.project, (IScribblerDomain)new DefaultScribblerDomain(){

                    public String getEditModelLabel() {
                        return String.valueOf(ModelFileIndex.this.project.getName()) + ".index";
                    }

                    public IResourceDescriptor[] getResourceDescriptors() {
                        return NO_DESCRIPTORS;
                    }
                });
            }
            catch (EditModelException e) {
                e.printStackTrace();
            }
        }
        return this.scribbler;
    }

    public void dispose() {
        if (this.scribbler == null) {
            try {
                this.scribbler.close(null);
            }
            catch (EditModelException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        String name = proxy.getName();
        if (name.endsWith("composite")) {
            this.addResource(proxy.requestResource());
        } else if (name.endsWith("componentType")) {
            this.addResource(proxy.requestResource());
        } else if (name.endsWith("module")) {
            this.addResource(proxy.requestResource());
        } else if (name.endsWith("subsystem")) {
            this.addResource(proxy.requestResource());
        }
        return true;
    }

    private void addResource(IResource resource) {
        if (resource.getType() == 1) {
            this.addModelFile((IFile)resource);
        }
    }
}

