/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;
import org.eclipse.stp.core.sca.impl.ComponentWireHandleImpl;

class ComponentWireTargetHandle
extends ComponentWireHandleImpl
implements WireTarget {
    private Service service;
    private String serviceName;

    ComponentWireTargetHandle(Component configurable, Service service) {
        super(configurable);
        this.service = service;
    }

    ComponentWireTargetHandle(Component configurable, String serviceName) {
        super(configurable);
        this.serviceName = serviceName;
    }

    private String getServiceName() {
        return this.service == null ? this.serviceName : this.service.getName();
    }

    public Interface getInterface() {
        return this.isResolved() ? this.service.getInterface() : null;
    }

    public boolean matches(WireSource wireSource) {
        Assert.isNotNull((Object)wireSource);
        if (this.getInterface() != null) {
            return this.getInterface().equals(wireSource.getInterface());
        }
        return false;
    }

    public int getFlags() {
        return 2;
    }

    public EObject getEObject() {
        return this.getOwningComponent().getEObject();
    }

    public void setName(String name) {
        Assert.isNotSupported((String)"ComponentWireTargetHandle#setName(String)");
    }

    public String getName() {
        StringBuffer buf = new StringBuffer(this.getOwningComponent().getName());
        buf.append('/').append(this.getServiceName());
        return buf.toString();
    }

    public String toString() {
        return this.getName();
    }

    void destroy() {
        this.service = null;
        super.destroy();
    }

    public boolean isResolved() {
        this.resolveService();
        return this.service != null;
    }

    private void resolveService() {
        ComponentType type = this.getOwningComponent().resolveComponentType();
        if (type != null) {
            Service test = type.getService(this.getServiceName());
            if (test != null) {
                this.service = test;
                this.serviceName = null;
            } else {
                if (this.service != null) {
                    this.serviceName = this.service.getName();
                }
                this.service = null;
            }
        }
    }
}

