package org.eclipse.stp.core.infrastructure.operations;

import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;

public abstract class AbstractScribblerDataModelProvider extends
      AbstractDataModelProvider implements
      IAbstractScribblerDataModelProperties {

   public IStatus validate(String name) {
      if (name.equals(SCRIBBLER_DOMAINS)) {
         return validateScribblerDomains();
      } else if (name.equals(EDIT_MODEL_LABEL)) {
         return validateEditModelLabel();
      } else if (name.equals(PROJECT_NAME)) {
         return validateProjectName();
      }

      return super.validate(name);
   }

   private IStatus validateEditModelLabel() {
      String editModelID = model
            .getStringProperty(IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL);

      if (editModelID == null || editModelID.length() == 0)
         return EMFInfrastructurePlugin.createErrorStatus(0,
               Messages.editModelIDBlank_errorText, null);

      return OK_STATUS;
   }

   private IStatus validateScribblerDomains() {
      IScribblerDomain[] domains = (IScribblerDomain[]) model
            .getProperty(IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS);
      if (domains == null || domains.length == 0)
         return EMFInfrastructurePlugin.createErrorStatus(0,
               Messages.needToProvideDomains_errorText, null);

      return OK_STATUS;
   }

   private IStatus validateProjectName() {
      String pName = getStringProperty(PROJECT_NAME);
      if (pName.length() < 1)
         return EMFInfrastructurePlugin.createErrorStatus(0,
               Messages.projectNameEmpty_errorText, null);

      if (getProject() == null)
         return EMFInfrastructurePlugin.createErrorStatus(0,
               Messages.projectDoesNotExist_errorText, null);

      // We may need to do additional checking here
      return OK_STATUS;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider#getPropertyNames()
    */
   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();
      propertyNames.add(SCRIBBLER_DOMAINS);
      propertyNames.add(EDIT_MODEL_LABEL);
      propertyNames.add(PROJECT_NAME);
      propertyNames.add(RESULT);

      return propertyNames;
   }

   public IProject getProject() {
      String pName = model.getStringProperty(PROJECT_NAME);
      if (pName != null && pName.length() > 0)
         return ProjectUtilities.getProject(pName);

      return null;
   }
}
