/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IComponentTypingDataModelProperties extends IAbstractScribblerDataModelProperties {
	
  	/** 
     * [OPTIONAL] A property that represents boolean flag that tells the operation if the 
     * type needs to be set (or reset).  By default this property is false (type reset).
     * 
     * Type = @link Boolean
     */
	String SET_TYPE = "IComponentTypingDataModelProperties.SET_TYPE";//$NON-NLS-1$
	
  	/** 
     * [REQUIRED] A property that represents type to be set.
     * 
     * Type = @link String
     */
	String TYPE = "IComponentTypingDataModelProperties.TYPE";//$NON-NLS-1$
	
	/** 
     * [REQUIRED] A property that holds the component instance that is to be typed.
     * 
     * Type = @link java.lang.Object
     */
	String COMPONENT = "IComponentTypingDataModelProperties.COMPONENT";//$NON-NLS-1$
}
