/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf;

import org.eclipse.stp.core.sca.SCAObject;

/**
 * This is the interface of the UI context object that the user program needs to
 * create and pass in as an argument to several methods provided by the handler
 * interfaces. This interface allows handlers to obtain the UI shell instance
 * needed to interact with the user program.
 */

public interface IUIContext {

	/**
	 * Returns an instance of the UI shell object representing the windows
	 * that the desktop or window manager is managing - see
	 * {@link org.eclipse.swt.widgets.Shell}
	 * 
	 * @return UI Shell
	 */
	public Object getShell();

	/**
	 * This method will evaluate the uniqueness of the given test name within
	 * the context for which this callback class was instantiated. For instance,
	 * if the test name is for a component, it will be checked to ensure it
	 * represents a unique component name within a given Module. If the name is
	 * unique, it will be returned as is. Otherwise, it will be modified to be
	 * unique and then returned.
	 * 
	 * @param testName
	 *            the name to test for the given object type
	 * @param objectType
	 *            the Component, EntryPoint or ExternalService for which the
	 *            name must be unique
	 * @return a unique name
	 */
	public String createName(String testName, SCAObject objectType);

}
