/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.handler;

/**
 * This class is to be extended by all interface handler contributions.  
 */
public abstract class AbstractInterfaceHandler extends AbstractHandler implements IInterfaceHandler {

	private IInterfaceLabelProvider labelProvider = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IInterfaceHandler#canCreateInterfaceFor(java.lang.Object)
	 */
	public boolean canCreateInterfaceFor(Object interfaceObj) {
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IInterfaceHandler#canCreateInterfaceObject()
	 */
	public boolean canCreateInterfaceObject() {
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IInterfaceHandler#getInterfaceLabelProvider()
	 */
	public final IInterfaceLabelProvider getInterfaceLabelProvider() {
		if(labelProvider == null)
			labelProvider = getLabelProviderInstance();
		return labelProvider;
	}

	/**
	 * Subclasses must implement this method to return an instance of
	 * {@link IInterfaceLabelProvider}. 
	 * 
	 * @return label provider instance
	 */
	protected abstract IInterfaceLabelProvider getLabelProviderInstance();	

}
