/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;

public class EMFUndoableOperation extends AbstractOperation implements
      IUndoableOperation {

   private Command emfCommand;

   public EMFUndoableOperation(Command anEmfCommand) {
      super(anEmfCommand.getLabel());
      emfCommand = anEmfCommand;
   }

   public boolean canExecute() {
      return emfCommand.canExecute();
   }

   public boolean canRedo() {
      // FOLLOWUP Need to decide what this means for EMF cmds
      return true;
   }

   public boolean canUndo() {
      return emfCommand.canUndo();
   }

   public void dispose() {
      emfCommand.dispose();

   }

   public IStatus execute(IProgressMonitor monitor, IAdaptable info)
         throws ExecutionException {
      emfCommand.execute();
      return Status.OK_STATUS;
   }

   public String getLabel() {
      return emfCommand.getLabel();
   }

   public IStatus redo(IProgressMonitor monitor, IAdaptable info)
         throws ExecutionException {
      // FOLLOWUP Should I catch any Runtime Exceptions and return a failed
      emfCommand.redo();
      return Status.OK_STATUS;

   }

   public IStatus undo(IProgressMonitor monitor, IAdaptable info)
         throws ExecutionException {
      emfCommand.undo();
      return Status.OK_STATUS;

   }

}
