/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class PropertyCreationDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IPropertyCreationDataModelProperties {

   public Object getDefaultProperty(String propertyName) {
      if (propertyName.equals(DEFAULT_VALUE))
         return null;
      if (propertyName.equals(REQUIRED))
         return new Boolean(true);
      if (propertyName.equals(MANY))
         return new Boolean(false);
      if (propertyName.equals(DEFAULT_VALUE))
         return null;

      return super.getDefaultProperty(propertyName);
   }

   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();

      propertyNames.add(COMPONENT_TYPE);
      propertyNames.add(NAME);
      propertyNames.add(DEFAULT_VALUE);
      propertyNames.add(TYPE);
      propertyNames.add(REQUIRED);
      propertyNames.add(MANY);

      return propertyNames;
   }

   public IStatus validate(String propertyName) {
      if (propertyName.equals(COMPONENT_TYPE)) {
         return validateComponentType();
      } else if (propertyName.equals(NAME)) {
         return validateName();
      }

      return super.validate(propertyName);
   }

   private IStatus validateComponentType() {
      Object obj = model.getProperty(COMPONENT_TYPE);
      if (obj == null || !(obj instanceof ComponentType))
         return STPCorePlugin.createErrorStatus(
               Messages.invalidObjectPassed_errorText, null);

      return OK_STATUS;
   }

   public IDataModelOperation getDefaultOperation() {
      return new PropertyCreationOperation(model);
   }

   private IStatus validateName() {
      // Here we will verify if the reference with same name already exits or
      // not for the component.
      // TODO implement validateName

      return Status.OK_STATUS;
   }
}
