/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/**
 * @author Manish Bhargava
 * 
 * IUndoableOperation for EObject which are root objects for a Resource.
 */
public abstract class RootSCAModelCreationOperation extends
      AbstractScribblerOperation {
   public RootSCAModelCreationOperation() {
      super();
   }

   public RootSCAModelCreationOperation(IDataModel model) {
      super(model);
   }

   public IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
      URI uri = getResourceURI();
      IEditModelScribbler scribbler = getEditModelScribbler();
      Assert.isNotNull(scribbler);

      // The following call will create the resource if it does not exist.
      Resource resource = scribbler.getResource(uri);
      if (resource != null) {
         SCACoreRoot root = null;
         if (resource.getContents() == null || resource.getContents().isEmpty()) {
            root = SCAPackage.eINSTANCE.getSCAFactory().createSCACoreRoot();
         } else {
            root = (SCACoreRoot) resource.getContents().get(0);
         }

         SCAObject addedObject = createAndAddSCAModelToRoot(root);
         resource.getContents().add((EObject) root);
         model.setProperty(IAbstractScribblerDataModelProperties.RESULT,
               addedObject);
      }

      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   /**
    * Operations extending this Operation should implement this method and
    * return the Resource URI whose root object will be the one that will get
    * created.
    */
   protected abstract URI getResourceURI();

   protected abstract SCAObject createAndAddSCAModelToRoot(SCACoreRoot root);
}
