/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ServiceCreationDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IServiceCreationDataModelProperties {

   public IDataModelOperation getDefaultOperation() {
      return new ServiceCreationOperation(model);
   }

   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();

      propertyNames.add(NAME);
      propertyNames.add(INTERFACE);
      propertyNames.add(INTERFACE_TYPE);
      propertyNames.add(COMPONENT_TYPE);

      return propertyNames;
   }

   public IStatus validate(String propertyName) {
      if (propertyName.equals(COMPONENT_TYPE)) {
         return validateComponentType();
      }

      return super.validate(propertyName);
   }

   private IStatus validateComponentType() {
      Object obj = model.getProperty(COMPONENT_TYPE);
      if (obj == null || !(obj instanceof ComponentType))
         return STPCorePlugin.createErrorStatus(
               Messages.invalidObjectPassed_errorText, null);

      return OK_STATUS;
   }
}
