/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import org.eclipse.stp.core.sca.impl.EObjectContainmentIntrospectingEList;

/**
 * A basic implementation for clients to subclass.
 * 
 * Clients must override {@link org.eclipse.core.runtime.ISafeRunnable#run()}
 * when subclassing.
 * 
 * @since 1.0
 * 
 */
public abstract class SafeIntrospector implements ISafeIntrospector {

   private EObjectContainmentIntrospectingEList targetList;

   /**
    * @return The target list that was passed in when the object was created.
    */
   public final EObjectContainmentIntrospectingEList getTargetList() {
      return targetList;
   }

   public void setTargetList(EObjectContainmentIntrospectingEList aList) {
      targetList = aList;
   }

   public void handleException(Throwable exception) {

   }

}
