/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.Map;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Core Root</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getMixed <em>Mixed</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getXSISchemaLocation <em>XSI Schema Location</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getAbstractComponent <em>Abstract Component</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getBinding <em>Binding</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingSca <em>Binding Sca</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getComponent <em>Component</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getComponentType <em>Component Type</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getComposite <em>Composite</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementation <em>Implementation</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationAbstract <em>Implementation Abstract</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationUnknown <em>Implementation Unknown</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getModule <em>Module</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getModuleComponent <em>Module Component</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getModuleFragment <em>Module Fragment</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getSource <em>Source</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getSourceEpr <em>Source Epr</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getSourceUri <em>Source Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getSubsystem <em>Subsystem</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getTarget <em>Target</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getTargetEpr <em>Target Epr</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getTargetUri <em>Target Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceWsdl <em>Interface Wsdl</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceJava <em>Interface Java</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingWs <em>Binding Ws</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationJava <em>Implementation Java</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingEjb <em>Binding Ejb</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot()
 * @model extendedMetaData="name='' kind='mixed'"
 * @extends SCAObject
 * @generated
 */
public interface SCACoreRoot extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Mixed</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Mixed</em>' attribute list isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Mixed</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Mixed()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard' name=':mixed'"
    * @generated
    */
   FeatureMap getMixed();

   /**
    * Returns the value of the '<em><b>XMLNS Prefix Map</b></em>' map. The
    * key is of type {@link java.lang.String}, and the value is of type
    * {@link java.lang.String}, <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>XMLNS Prefix Map</em>' map isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>XMLNS Prefix Map</em>' map.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_XMLNSPrefixMap()
    * @model mapType="org.eclipse.emf.ecore.EStringToStringMapEntry"
    *        keyType="java.lang.String" valueType="java.lang.String"
    *        transient="true" extendedMetaData="kind='attribute'
    *        name='xmlns:prefix'"
    * @generated
    */
   Map getXMLNSPrefixMap();

   /**
    * Returns the value of the '<em><b>XSI Schema Location</b></em>' map.
    * The key is of type {@link java.lang.String}, and the value is of type
    * {@link java.lang.String}, <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>XSI Schema Location</em>' map isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>XSI Schema Location</em>' map.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_XSISchemaLocation()
    * @model mapType="org.eclipse.emf.ecore.EStringToStringMapEntry"
    *        keyType="java.lang.String" valueType="java.lang.String"
    *        transient="true" extendedMetaData="kind='attribute'
    *        name='xsi:schemaLocation'"
    * @generated
    */
   Map getXSISchemaLocation();

   /**
    * Returns the value of the '<em><b>Abstract Component</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Abstract Component</em>' containment
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Abstract Component</em>' containment
    *         reference.
    * @see #setAbstractComponent(Component)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_AbstractComponent()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='abstractComponent'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Component getAbstractComponent();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getAbstractComponent <em>Abstract Component</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Abstract Component</em>'
    *           containment reference.
    * @see #getAbstractComponent()
    * @generated
    */
   void setAbstractComponent(Component value);

   /**
    * Returns the value of the '<em><b>Binding</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Binding</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Binding</em>' containment reference.
    * @see #setBinding(Binding)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Binding()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='binding'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Binding getBinding();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBinding <em>Binding</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Binding</em>' containment
    *           reference.
    * @see #getBinding()
    * @generated
    */
   void setBinding(Binding value);

   /**
    * Returns the value of the '<em><b>Binding Sca</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Binding Sca</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Binding Sca</em>' containment reference.
    * @see #setBindingSca(SCABinding)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_BindingSca()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='binding.sca'
    *        namespace='##targetNamespace' affiliation='binding'"
    * @generated
    */
   SCABinding getBindingSca();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingSca <em>Binding Sca</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Binding Sca</em>' containment
    *           reference.
    * @see #getBindingSca()
    * @generated
    */
   void setBindingSca(SCABinding value);

   /**
    * Returns the value of the '<em><b>Component</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Component</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Component</em>' containment reference.
    * @see #setComponent(ImplementationComponent)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Component()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='component'
    *        namespace='##targetNamespace' affiliation='abstractComponent'"
    * @generated
    */
   ImplementationComponent getComponent();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getComponent <em>Component</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Component</em>' containment
    *           reference.
    * @see #getComponent()
    * @generated
    */
   void setComponent(ImplementationComponent value);

   /**
    * Returns the value of the '<em><b>Component Type</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Component Type</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Component Type</em>' containment
    *         reference.
    * @see #setComponentType(ComponentType)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_ComponentType()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='componentType'
    *        namespace='##targetNamespace'"
    * @generated
    */
   ComponentType getComponentType();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getComponentType <em>Component Type</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Component Type</em>' containment
    *           reference.
    * @see #getComponentType()
    * @generated
    */
   void setComponentType(ComponentType value);

   /**
    * Returns the value of the '<em><b>Composite</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Composite</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Composite</em>' containment reference.
    * @see #setComposite(Composite)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Composite()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='composite'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Composite getComposite();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getComposite <em>Composite</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Composite</em>' containment
    *           reference.
    * @see #getComposite()
    * @generated
    */
   void setComposite(Composite value);

   /**
    * Returns the value of the '<em><b>Implementation</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Implementation</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Implementation</em>' containment
    *         reference.
    * @see #setImplementation(Implementation)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Implementation()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='implementation'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Implementation getImplementation();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementation <em>Implementation</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Implementation</em>' containment
    *           reference.
    * @see #getImplementation()
    * @generated
    */
   void setImplementation(Implementation value);

   /**
    * Returns the value of the '<em><b>Implementation Abstract</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Implementation Abstract</em>' containment
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Implementation Abstract</em>'
    *         containment reference.
    * @see #setImplementationAbstract(AbstractImplementation)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_ImplementationAbstract()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='implementation.abstract'
    *        namespace='##targetNamespace' affiliation='implementation'"
    * @generated
    */
   AbstractImplementation getImplementationAbstract();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationAbstract <em>Implementation Abstract</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Implementation Abstract</em>'
    *           containment reference.
    * @see #getImplementationAbstract()
    * @generated
    */
   void setImplementationAbstract(AbstractImplementation value);

   /**
    * Returns the value of the '<em><b>Implementation Unknown</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Implementation Unknown</em>' containment
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Implementation Unknown</em>' containment
    *         reference.
    * @see #setImplementationUnknown(UnknownImplementation)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_ImplementationUnknown()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='implementation.unknown'
    *        namespace='##targetNamespace' affiliation='implementation'"
    * @generated
    */
   UnknownImplementation getImplementationUnknown();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationUnknown <em>Implementation Unknown</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Implementation Unknown</em>'
    *           containment reference.
    * @see #getImplementationUnknown()
    * @generated
    */
   void setImplementationUnknown(UnknownImplementation value);

   /**
    * Returns the value of the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Interface</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Interface</em>' containment reference.
    * @see #setInterface(Interface)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Interface()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='interface'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Interface getInterface();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterface <em>Interface</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Interface</em>' containment
    *           reference.
    * @see #getInterface()
    * @generated
    */
   void setInterface(Interface value);

   /**
    * Returns the value of the '<em><b>Module</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Module</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Module</em>' containment reference.
    * @see #setModule(Module)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Module()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='module'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Module getModule();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getModule <em>Module</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Module</em>' containment
    *           reference.
    * @see #getModule()
    * @generated
    */
   void setModule(Module value);

   /**
    * Returns the value of the '<em><b>Module Component</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Module Component</em>' containment
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Module Component</em>' containment
    *         reference.
    * @see #setModuleComponent(ModuleComponent)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_ModuleComponent()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='moduleComponent'
    *        namespace='##targetNamespace' affiliation='abstractComponent'"
    * @generated
    */
   ModuleComponent getModuleComponent();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getModuleComponent <em>Module Component</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Module Component</em>' containment
    *           reference.
    * @see #getModuleComponent()
    * @generated
    */
   void setModuleComponent(ModuleComponent value);

   /**
    * Returns the value of the '<em><b>Module Fragment</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Module Fragment</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Module Fragment</em>' containment
    *         reference.
    * @see #setModuleFragment(ModuleFragment)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_ModuleFragment()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='moduleFragment'
    *        namespace='##targetNamespace'"
    * @generated
    */
   ModuleFragment getModuleFragment();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getModuleFragment <em>Module Fragment</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Module Fragment</em>' containment
    *           reference.
    * @see #getModuleFragment()
    * @generated
    */
   void setModuleFragment(ModuleFragment value);

   /**
    * Returns the value of the '<em><b>Source</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Source</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Source</em>' containment reference.
    * @see #setSource(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Source()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='source'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Object getSource();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSource <em>Source</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Source</em>' containment
    *           reference.
    * @see #getSource()
    * @generated
    */
   void setSource(Object value);

   /**
    * Returns the value of the '<em><b>Source Epr</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Source Epr</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Source Epr</em>' containment reference.
    * @see #setSourceEpr(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_SourceEpr()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='source.epr'
    *        namespace='##targetNamespace' affiliation='source'"
    * @generated
    */
   Object getSourceEpr();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSourceEpr <em>Source Epr</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Source Epr</em>' containment
    *           reference.
    * @see #getSourceEpr()
    * @generated
    */
   void setSourceEpr(Object value);

   /**
    * Returns the value of the '<em><b>Source Uri</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Source Uri</em>' attribute isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Source Uri</em>' attribute.
    * @see #setSourceUri(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_SourceUri()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        upper="-2" transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='source.uri'
    *        namespace='##targetNamespace' affiliation='source'"
    * @generated
    */
   String getSourceUri();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSourceUri <em>Source Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Source Uri</em>' attribute.
    * @see #getSourceUri()
    * @generated
    */
   void setSourceUri(String value);

   /**
    * Returns the value of the '<em><b>Subsystem</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Subsystem</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Subsystem</em>' containment reference.
    * @see #setSubsystem(Subsystem)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Subsystem()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='subsystem'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Subsystem getSubsystem();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSubsystem <em>Subsystem</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Subsystem</em>' containment
    *           reference.
    * @see #getSubsystem()
    * @generated
    */
   void setSubsystem(Subsystem value);

   /**
    * Returns the value of the '<em><b>Target</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Target</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Target</em>' containment reference.
    * @see #setTarget(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_Target()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='target'
    *        namespace='##targetNamespace'"
    * @generated
    */
   Object getTarget();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getTarget <em>Target</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Target</em>' containment
    *           reference.
    * @see #getTarget()
    * @generated
    */
   void setTarget(Object value);

   /**
    * Returns the value of the '<em><b>Target Epr</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Target Epr</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Target Epr</em>' containment reference.
    * @see #setTargetEpr(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_TargetEpr()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='target.epr'
    *        namespace='##targetNamespace' affiliation='target'"
    * @generated
    */
   Object getTargetEpr();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getTargetEpr <em>Target Epr</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Target Epr</em>' containment
    *           reference.
    * @see #getTargetEpr()
    * @generated
    */
   void setTargetEpr(Object value);

   /**
    * Returns the value of the '<em><b>Target Uri</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Target Uri</em>' attribute isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Target Uri</em>' attribute.
    * @see #setTargetUri(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_TargetUri()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        upper="-2" transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='target.uri'
    *        namespace='##targetNamespace' affiliation='target'"
    * @generated
    */
   String getTargetUri();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getTargetUri <em>Target Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Target Uri</em>' attribute.
    * @see #getTargetUri()
    * @generated
    */
   void setTargetUri(String value);

   /**
    * Returns the value of the '<em><b>Interface Wsdl</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Interface Wsdl</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Interface Wsdl</em>' containment
    *         reference.
    * @see #setInterfaceWsdl(WSDLPortType)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_InterfaceWsdl()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='interface.wsdl'
    *        namespace='##targetNamespace' affiliation='interface'"
    * @generated
    */
   WSDLPortType getInterfaceWsdl();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceWsdl <em>Interface Wsdl</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Interface Wsdl</em>' containment
    *           reference.
    * @see #getInterfaceWsdl()
    * @generated
    */
   void setInterfaceWsdl(WSDLPortType value);

   /**
    * Returns the value of the '<em><b>Interface Java</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Interface Java</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Interface Java</em>' containment
    *         reference.
    * @see #setInterfaceJava(JavaInterface)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_InterfaceJava()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='interface.java'
    *        namespace='##targetNamespace' affiliation='interface'"
    * @generated
    */
   JavaInterface getInterfaceJava();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceJava <em>Interface Java</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Interface Java</em>' containment
    *           reference.
    * @see #getInterfaceJava()
    * @generated
    */
   void setInterfaceJava(JavaInterface value);

   /**
    * Returns the value of the '<em><b>Binding Ws</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Binding Ws</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Binding Ws</em>' containment reference.
    * @see #setBindingWs(WebServiceBinding)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_BindingWs()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='binding.ws'
    *        namespace='##targetNamespace' affiliation='binding'"
    * @generated
    */
   WebServiceBinding getBindingWs();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingWs <em>Binding Ws</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Binding Ws</em>' containment
    *           reference.
    * @see #getBindingWs()
    * @generated
    */
   void setBindingWs(WebServiceBinding value);

   /**
    * Returns the value of the '<em><b>Implementation Java</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Implementation Java</em>' containment
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Implementation Java</em>' containment
    *         reference.
    * @see #setImplementationJava(JavaImplementation)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_ImplementationJava()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='implementation.java'
    *        namespace='##targetNamespace' affiliation='implementation'"
    * @generated
    */
   JavaImplementation getImplementationJava();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationJava <em>Implementation Java</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Implementation Java</em>'
    *           containment reference.
    * @see #getImplementationJava()
    * @generated
    */
   void setImplementationJava(JavaImplementation value);

   /**
    * Returns the value of the '<em><b>Binding Ejb</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Binding Ejb</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Binding Ejb</em>' containment reference.
    * @see #setBindingEjb(SLSBBinding)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSCACoreRoot_BindingEjb()
    * @model containment="true" resolveProxies="false" upper="-2"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='binding.ejb'
    *        namespace='##targetNamespace' affiliation='binding'"
    * @generated
    */
   SLSBBinding getBindingEjb();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingEjb <em>Binding Ejb</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Binding Ejb</em>' containment
    *           reference.
    * @see #getBindingEjb()
    * @generated
    */
   void setBindingEjb(SLSBBinding value);

} // SCACoreRoot
