/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.sca.SCAFactory
 * @model kind="package"
 * @generated
 */
public interface SCAPackage extends EPackage {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String     copyright                                      = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String     eNAME                                          = "sca";                                                                                                //$NON-NLS-1$

   /**
    * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String     eNS_URI                                        = "http://www.osoa.org/xmlns/sca/0.9";                                                                  //$NON-NLS-1$

   /**
    * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String     eNS_PREFIX                                     = "sca";                                                                                                //$NON-NLS-1$

   /**
    * The singleton instance of the package. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   SCAPackage eINSTANCE                                      = org.eclipse.stp.core.sca.impl.SCAPackageImpl
                                                                   .init();

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.BindingImpl <em>Binding</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.BindingImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getBinding()
    * @generated
    */
   int        BINDING                                        = 1;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ComponentImpl <em>Component</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ComponentImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getComponent()
    * @generated
    */
   int        COMPONENT                                      = 2;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ComponentTypeImpl <em>Component Type</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ComponentTypeImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getComponentType()
    * @generated
    */
   int        COMPONENT_TYPE                                 = 3;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.CompositeImpl <em>Composite</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.CompositeImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getComposite()
    * @generated
    */
   int        COMPOSITE                                      = 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.EntryPointImpl <em>Entry Point</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.EntryPointImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getEntryPoint()
    * @generated
    */
   int        ENTRY_POINT                                    = 5;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl <em>External Service</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ExternalServiceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getExternalService()
    * @generated
    */
   int        EXTERNAL_SERVICE                               = 6;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ImplementationImpl <em>Implementation</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ImplementationImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getImplementation()
    * @generated
    */
   int        IMPLEMENTATION                                 = 7;

   /**
    * The number of structural features of the the '<em>Implementation</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_FEATURE_COUNT                   = 0;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.AbstractImplementationImpl <em>Abstract Implementation</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.AbstractImplementationImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getAbstractImplementation()
    * @generated
    */
   int        ABSTRACT_IMPLEMENTATION                        = 0;

   /**
    * The feature id for the '<em><b>Component Type</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ABSTRACT_IMPLEMENTATION__COMPONENT_TYPE        = IMPLEMENTATION_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Type</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ABSTRACT_IMPLEMENTATION__TYPE                  = IMPLEMENTATION_FEATURE_COUNT + 1;

   /**
    * The number of structural features of the the '<em>Abstract Implementation</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ABSTRACT_IMPLEMENTATION_FEATURE_COUNT          = IMPLEMENTATION_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        BINDING__URI                                   = 0;

   /**
    * The number of structural features of the the '<em>Binding</em>' class.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        BINDING_FEATURE_COUNT                          = 1;

   /**
    * The feature id for the '<em><b>Property Values Set</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT__PROPERTY_VALUES_SET                 = 0;

   /**
    * The feature id for the '<em><b>Reference Values Set</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT__REFERENCE_VALUES_SET                = 1;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT__NAME                                = 2;

   /**
    * The number of structural features of the the '<em>Component</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_FEATURE_COUNT                        = 3;

   /**
    * The feature id for the '<em><b>Services</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_TYPE__SERVICES                       = 0;

   /**
    * The feature id for the '<em><b>References</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_TYPE__REFERENCES                     = 1;

   /**
    * The feature id for the '<em><b>Properties</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_TYPE__PROPERTIES                     = 2;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_TYPE__ANY                            = 3;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_TYPE__ANY_ATTRIBUTE                  = 4;

   /**
    * The number of structural features of the the '<em>Component Type</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPONENT_TYPE_FEATURE_COUNT                   = 5;

   /**
    * The feature id for the '<em><b>Entry Points</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPOSITE__ENTRY_POINTS                        = 0;

   /**
    * The feature id for the '<em><b>Components Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPOSITE__COMPONENTS_GROUP                    = 1;

   /**
    * The feature id for the '<em><b>Components</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPOSITE__COMPONENTS                          = 2;

   /**
    * The feature id for the '<em><b>External Services</b></em>'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPOSITE__EXTERNAL_SERVICES                   = 3;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPOSITE__NAME                                = 4;

   /**
    * The number of structural features of the the '<em>Composite</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        COMPOSITE_FEATURE_COUNT                        = 5;

   /**
    * The feature id for the '<em><b>Interface Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__INTERFACE_GROUP                   = 0;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__INTERFACE                         = 1;

   /**
    * The feature id for the '<em><b>Binding Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__BINDING_GROUP                     = 2;

   /**
    * The feature id for the '<em><b>Bindings</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__BINDINGS                          = 3;

   /**
    * The feature id for the '<em><b>Reference Targets</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__REFERENCE_TARGETS                 = 4;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__ANY                               = 5;

   /**
    * The feature id for the '<em><b>Multiplicity</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__MULTIPLICITY                      = 6;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__NAME                              = 7;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT__ANY_ATTRIBUTE                     = 8;

   /**
    * The number of structural features of the the '<em>Entry Point</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        ENTRY_POINT_FEATURE_COUNT                      = 9;

   /**
    * The feature id for the '<em><b>Binding Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__BINDING_GROUP                = 0;

   /**
    * The feature id for the '<em><b>Bindings</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__BINDINGS                     = 1;

   /**
    * The feature id for the '<em><b>Interface Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__INTERFACE_GROUP              = 2;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__INTERFACE                    = 3;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__ANY                          = 4;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__NAME                         = 5;

   /**
    * The feature id for the '<em><b>Overridable</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__OVERRIDABLE                  = 6;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE__ANY_ATTRIBUTE                = 7;

   /**
    * The number of structural features of the the '<em>External Service</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        EXTERNAL_SERVICE_FEATURE_COUNT                 = 8;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ImplementationComponentImpl <em>Implementation Component</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ImplementationComponentImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getImplementationComponent()
    * @generated
    */
   int        IMPLEMENTATION_COMPONENT                       = 8;

   /**
    * The feature id for the '<em><b>Property Values Set</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__PROPERTY_VALUES_SET  = COMPONENT__PROPERTY_VALUES_SET;

   /**
    * The feature id for the '<em><b>Reference Values Set</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET = COMPONENT__REFERENCE_VALUES_SET;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__NAME                 = COMPONENT__NAME;

   /**
    * The feature id for the '<em><b>Implementation Group</b></em>'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP = COMPONENT_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Implementation</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__IMPLEMENTATION       = COMPONENT_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__ANY                  = COMPONENT_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE        = COMPONENT_FEATURE_COUNT + 3;

   /**
    * The number of structural features of the the '<em>Implementation Component</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        IMPLEMENTATION_COMPONENT_FEATURE_COUNT         = COMPONENT_FEATURE_COUNT + 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.InterfaceImpl <em>Interface</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.InterfaceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getInterface()
    * @generated
    */
   int        INTERFACE                                      = 9;

   /**
    * The number of structural features of the the '<em>Interface</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        INTERFACE_FEATURE_COUNT                        = 0;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.JavaImplementationImpl <em>Java Implementation</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.JavaImplementationImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getJavaImplementation()
    * @generated
    */
   int        JAVA_IMPLEMENTATION                            = 10;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_IMPLEMENTATION__ANY                       = IMPLEMENTATION_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Class</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_IMPLEMENTATION__CLASS                     = IMPLEMENTATION_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_IMPLEMENTATION__ANY_ATTRIBUTE             = IMPLEMENTATION_FEATURE_COUNT + 2;

   /**
    * The number of structural features of the the '<em>Java Implementation</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_IMPLEMENTATION_FEATURE_COUNT              = IMPLEMENTATION_FEATURE_COUNT + 3;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.JavaInterfaceImpl <em>Java Interface</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.JavaInterfaceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getJavaInterface()
    * @generated
    */
   int        JAVA_INTERFACE                                 = 11;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_INTERFACE__ANY                            = INTERFACE_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Callback Interface</b></em>'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_INTERFACE__CALLBACK_INTERFACE             = INTERFACE_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Interface</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_INTERFACE__INTERFACE                      = INTERFACE_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_INTERFACE__ANY_ATTRIBUTE                  = INTERFACE_FEATURE_COUNT + 3;

   /**
    * The number of structural features of the the '<em>Java Interface</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        JAVA_INTERFACE_FEATURE_COUNT                   = INTERFACE_FEATURE_COUNT + 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ModuleFragmentImpl <em>Module Fragment</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ModuleFragmentImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getModuleFragment()
    * @generated
    */
   int        MODULE_FRAGMENT                                = 14;

   /**
    * The feature id for the '<em><b>Entry Points</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__ENTRY_POINTS                  = COMPOSITE__ENTRY_POINTS;

   /**
    * The feature id for the '<em><b>Components Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__COMPONENTS_GROUP              = COMPOSITE__COMPONENTS_GROUP;

   /**
    * The feature id for the '<em><b>Components</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__COMPONENTS                    = COMPOSITE__COMPONENTS;

   /**
    * The feature id for the '<em><b>External Services</b></em>'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__EXTERNAL_SERVICES             = COMPOSITE__EXTERNAL_SERVICES;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__NAME                          = COMPOSITE__NAME;

   /**
    * The feature id for the '<em><b>Wires</b></em>' containment reference
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__WIRES                         = COMPOSITE_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__ANY                           = COMPOSITE_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT__ANY_ATTRIBUTE                 = COMPOSITE_FEATURE_COUNT + 2;

   /**
    * The number of structural features of the the '<em>Module Fragment</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FRAGMENT_FEATURE_COUNT                  = COMPOSITE_FEATURE_COUNT + 3;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ModuleImpl <em>Module</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ModuleImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getModule()
    * @generated
    */
   int        MODULE                                         = 12;

   /**
    * The feature id for the '<em><b>Entry Points</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__ENTRY_POINTS                           = MODULE_FRAGMENT__ENTRY_POINTS;

   /**
    * The feature id for the '<em><b>Components Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__COMPONENTS_GROUP                       = MODULE_FRAGMENT__COMPONENTS_GROUP;

   /**
    * The feature id for the '<em><b>Components</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__COMPONENTS                             = MODULE_FRAGMENT__COMPONENTS;

   /**
    * The feature id for the '<em><b>External Services</b></em>'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__EXTERNAL_SERVICES                      = MODULE_FRAGMENT__EXTERNAL_SERVICES;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__NAME                                   = MODULE_FRAGMENT__NAME;

   /**
    * The feature id for the '<em><b>Wires</b></em>' containment reference
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__WIRES                                  = MODULE_FRAGMENT__WIRES;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__ANY                                    = MODULE_FRAGMENT__ANY;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE__ANY_ATTRIBUTE                          = MODULE_FRAGMENT__ANY_ATTRIBUTE;

   /**
    * The number of structural features of the the '<em>Module</em>' class.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_FEATURE_COUNT                           = MODULE_FRAGMENT_FEATURE_COUNT + 0;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ModuleComponentImpl <em>Module Component</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ModuleComponentImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getModuleComponent()
    * @generated
    */
   int        MODULE_COMPONENT                               = 13;

   /**
    * The feature id for the '<em><b>Property Values Set</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__PROPERTY_VALUES_SET          = COMPONENT__PROPERTY_VALUES_SET;

   /**
    * The feature id for the '<em><b>Reference Values Set</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__REFERENCE_VALUES_SET         = COMPONENT__REFERENCE_VALUES_SET;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__NAME                         = COMPONENT__NAME;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__ANY                          = COMPONENT_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Module</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__MODULE                       = COMPONENT_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__URI                          = COMPONENT_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT__ANY_ATTRIBUTE                = COMPONENT_FEATURE_COUNT + 3;

   /**
    * The number of structural features of the the '<em>Module Component</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_COMPONENT_FEATURE_COUNT                 = COMPONENT_FEATURE_COUNT + 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ModuleWireImpl <em>Module Wire</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ModuleWireImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getModuleWire()
    * @generated
    */
   int        MODULE_WIRE                                    = 17;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.PropertyImpl <em>Property</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.PropertyImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getProperty()
    * @generated
    */
   int        PROPERTY                                       = 18;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.PropertyValueImpl <em>Property Value</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.PropertyValueImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getPropertyValue()
    * @generated
    */
   int        PROPERTY_VALUE                                 = 19;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.PropertyValuesSetImpl <em>Property Values Set</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.PropertyValuesSetImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getPropertyValuesSet()
    * @generated
    */
   int        PROPERTY_VALUES_SET                            = 20;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ReferenceImpl <em>Reference</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ReferenceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getReference()
    * @generated
    */
   int        REFERENCE                                      = 21;

   /**
    * The feature id for the '<em><b>Interface Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE__INTERFACE_GROUP                     = 0;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE__INTERFACE                           = 1;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE__ANY                                 = 2;

   /**
    * The feature id for the '<em><b>Multiplicity</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE__MULTIPLICITY                        = 3;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE__NAME                                = 4;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE__ANY_ATTRIBUTE                       = 5;

   /**
    * The number of structural features of the the '<em>Reference</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_FEATURE_COUNT                        = 6;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ModuleReferenceImpl <em>Module Reference</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ModuleReferenceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getModuleReference()
    * @generated
    */
   int        MODULE_REFERENCE                               = 15;

   /**
    * The feature id for the '<em><b>Interface Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__INTERFACE_GROUP              = REFERENCE__INTERFACE_GROUP;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__INTERFACE                    = REFERENCE__INTERFACE;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__ANY                          = REFERENCE__ANY;

   /**
    * The feature id for the '<em><b>Multiplicity</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__MULTIPLICITY                 = REFERENCE__MULTIPLICITY;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__NAME                         = REFERENCE__NAME;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__ANY_ATTRIBUTE                = REFERENCE__ANY_ATTRIBUTE;

   /**
    * The feature id for the '<em><b>External Service</b></em>' reference.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE__EXTERNAL_SERVICE             = REFERENCE_FEATURE_COUNT + 0;

   /**
    * The number of structural features of the the '<em>Module Reference</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_REFERENCE_FEATURE_COUNT                 = REFERENCE_FEATURE_COUNT + 1;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ReferenceValueImpl <em>Reference Value</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ReferenceValueImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getReferenceValue()
    * @generated
    */
   int        REFERENCE_VALUE                                = 22;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ReferenceValuesSetImpl <em>Reference Values Set</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ReferenceValuesSetImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getReferenceValuesSet()
    * @generated
    */
   int        REFERENCE_VALUES_SET                           = 23;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.SCABindingImpl <em>Binding</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.SCABindingImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getSCABinding()
    * @generated
    */
   int        SCA_BINDING                                    = 24;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl <em>Core Root</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.SCACoreRootImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getSCACoreRoot()
    * @generated
    */
   int        SCA_CORE_ROOT                                  = 25;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ServiceImpl <em>Service</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ServiceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getService()
    * @generated
    */
   int        SERVICE                                        = 26;

   /**
    * The feature id for the '<em><b>Interface Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SERVICE__INTERFACE_GROUP                       = 0;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SERVICE__INTERFACE                             = 1;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SERVICE__ANY                                   = 2;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SERVICE__NAME                                  = 3;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SERVICE__ANY_ATTRIBUTE                         = 4;

   /**
    * The number of structural features of the the '<em>Service</em>' class.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SERVICE_FEATURE_COUNT                          = 5;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.ModuleServiceImpl <em>Module Service</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.ModuleServiceImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getModuleService()
    * @generated
    */
   int        MODULE_SERVICE                                 = 16;

   /**
    * The feature id for the '<em><b>Interface Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE__INTERFACE_GROUP                = SERVICE__INTERFACE_GROUP;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE__INTERFACE                      = SERVICE__INTERFACE;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE__ANY                            = SERVICE__ANY;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE__NAME                           = SERVICE__NAME;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE__ANY_ATTRIBUTE                  = SERVICE__ANY_ATTRIBUTE;

   /**
    * The feature id for the '<em><b>Entry Point</b></em>' reference. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE__ENTRY_POINT                    = SERVICE_FEATURE_COUNT + 0;

   /**
    * The number of structural features of the the '<em>Module Service</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_SERVICE_FEATURE_COUNT                   = SERVICE_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Source Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_WIRE__SOURCE_URI                        = 0;

   /**
    * The feature id for the '<em><b>Target Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_WIRE__TARGET_URI                        = 1;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_WIRE__ANY                               = 2;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_WIRE__ANY_ATTRIBUTE                     = 3;

   /**
    * The number of structural features of the the '<em>Module Wire</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        MODULE_WIRE_FEATURE_COUNT                      = 4;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__ANY                                  = 0;

   /**
    * The feature id for the '<em><b>Default</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__DEFAULT                              = 1;

   /**
    * The feature id for the '<em><b>Many</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__MANY                                 = 2;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__NAME                                 = 3;

   /**
    * The feature id for the '<em><b>Required</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__REQUIRED                             = 4;

   /**
    * The feature id for the '<em><b>Type</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__TYPE                                 = 5;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY__ANY_ATTRIBUTE                        = 6;

   /**
    * The number of structural features of the the '<em>Property</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_FEATURE_COUNT                         = 7;

   /**
    * The feature id for the '<em><b>Value</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_VALUE__VALUE                          = 0;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_VALUE__NAME                           = 1;

   /**
    * The number of structural features of the the '<em>Property Value</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_VALUE_FEATURE_COUNT                   = 2;

   /**
    * The feature id for the '<em><b>Property Values</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_VALUES_SET__PROPERTY_VALUES           = 0;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_VALUES_SET__ANY_ATTRIBUTE             = 1;

   /**
    * The number of structural features of the the '<em>Property Values Set</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        PROPERTY_VALUES_SET_FEATURE_COUNT              = 2;

   /**
    * The feature id for the '<em><b>Target URI</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUE__TARGET_URI                    = 0;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUE__NAME                          = 1;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUE__ANY_ATTRIBUTE                 = 2;

   /**
    * The feature id for the '<em><b>Reference Value Set</b></em>'
    * container reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUE__REFERENCE_VALUE_SET           = 3;

   /**
    * The number of structural features of the the '<em>Reference Value</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUE_FEATURE_COUNT                  = 4;

   /**
    * The feature id for the '<em><b>Reference Values</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUES_SET__REFERENCE_VALUES         = 0;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUES_SET__ANY_ATTRIBUTE            = 1;

   /**
    * The feature id for the '<em><b>Component</b></em>' container
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUES_SET__COMPONENT                = 2;

   /**
    * The number of structural features of the the '<em>Reference Values Set</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        REFERENCE_VALUES_SET_FEATURE_COUNT             = 3;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_BINDING__URI                               = BINDING__URI;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_BINDING__ANY                               = BINDING_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_BINDING__ANY_ATTRIBUTE                     = BINDING_FEATURE_COUNT + 1;

   /**
    * The number of structural features of the the '<em>Binding</em>' class.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_BINDING_FEATURE_COUNT                      = BINDING_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Mixed</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__MIXED                           = 0;

   /**
    * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__XMLNS_PREFIX_MAP                = 1;

   /**
    * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__XSI_SCHEMA_LOCATION             = 2;

   /**
    * The feature id for the '<em><b>Abstract Component</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__ABSTRACT_COMPONENT              = 3;

   /**
    * The feature id for the '<em><b>Binding</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__BINDING                         = 4;

   /**
    * The feature id for the '<em><b>Binding Sca</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__BINDING_SCA                     = 5;

   /**
    * The feature id for the '<em><b>Component</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__COMPONENT                       = 6;

   /**
    * The feature id for the '<em><b>Component Type</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__COMPONENT_TYPE                  = 7;

   /**
    * The feature id for the '<em><b>Composite</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__COMPOSITE                       = 8;

   /**
    * The feature id for the '<em><b>Implementation</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__IMPLEMENTATION                  = 9;

   /**
    * The feature id for the '<em><b>Implementation Abstract</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT         = 10;

   /**
    * The feature id for the '<em><b>Implementation Unknown</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN          = 11;

   /**
    * The feature id for the '<em><b>Interface</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__INTERFACE                       = 12;

   /**
    * The feature id for the '<em><b>Module</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__MODULE                          = 13;

   /**
    * The feature id for the '<em><b>Module Component</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__MODULE_COMPONENT                = 14;

   /**
    * The feature id for the '<em><b>Module Fragment</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__MODULE_FRAGMENT                 = 15;

   /**
    * The feature id for the '<em><b>Source</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__SOURCE                          = 16;

   /**
    * The feature id for the '<em><b>Source Epr</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__SOURCE_EPR                      = 17;

   /**
    * The feature id for the '<em><b>Source Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__SOURCE_URI                      = 18;

   /**
    * The feature id for the '<em><b>Subsystem</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__SUBSYSTEM                       = 19;

   /**
    * The feature id for the '<em><b>Target</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__TARGET                          = 20;

   /**
    * The feature id for the '<em><b>Target Epr</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__TARGET_EPR                      = 21;

   /**
    * The feature id for the '<em><b>Target Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__TARGET_URI                      = 22;

   /**
    * The feature id for the '<em><b>Interface Wsdl</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__INTERFACE_WSDL                  = 23;

   /**
    * The feature id for the '<em><b>Interface Java</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__INTERFACE_JAVA                  = 24;

   /**
    * The feature id for the '<em><b>Binding Ws</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__BINDING_WS                      = 25;

   /**
    * The feature id for the '<em><b>Implementation Java</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__IMPLEMENTATION_JAVA             = 26;

   /**
    * The feature id for the '<em><b>Binding Ejb</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT__BINDING_EJB                     = 27;

   /**
    * The number of structural features of the the '<em>Core Root</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SCA_CORE_ROOT_FEATURE_COUNT                    = 28;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.SLSBBindingImpl <em>SLSB Binding</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.SLSBBindingImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getSLSBBinding()
    * @generated
    */
   int        SLSB_BINDING                                   = 27;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SLSB_BINDING__URI                              = BINDING__URI;

   /**
    * The feature id for the '<em><b>Jndi Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SLSB_BINDING__JNDI_NAME                        = BINDING_FEATURE_COUNT + 0;

   /**
    * The number of structural features of the the '<em>SLSB Binding</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SLSB_BINDING_FEATURE_COUNT                     = BINDING_FEATURE_COUNT + 1;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.SubsystemImpl <em>Subsystem</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.SubsystemImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getSubsystem()
    * @generated
    */
   int        SUBSYSTEM                                      = 28;

   /**
    * The feature id for the '<em><b>Entry Points</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__ENTRY_POINTS                        = COMPOSITE__ENTRY_POINTS;

   /**
    * The feature id for the '<em><b>Components Group</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__COMPONENTS_GROUP                    = COMPOSITE__COMPONENTS_GROUP;

   /**
    * The feature id for the '<em><b>Components</b></em>' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__COMPONENTS                          = COMPOSITE__COMPONENTS;

   /**
    * The feature id for the '<em><b>External Services</b></em>'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__EXTERNAL_SERVICES                   = COMPOSITE__EXTERNAL_SERVICES;

   /**
    * The feature id for the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__NAME                                = COMPOSITE__NAME;

   /**
    * The feature id for the '<em><b>Wires</b></em>' containment reference
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__WIRES                               = COMPOSITE_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__ANY                                 = COMPOSITE_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__URI                                 = COMPOSITE_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM__ANY_ATTRIBUTE                       = COMPOSITE_FEATURE_COUNT + 3;

   /**
    * The number of structural features of the the '<em>Subsystem</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SUBSYSTEM_FEATURE_COUNT                        = COMPOSITE_FEATURE_COUNT + 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.SystemWireImpl <em>System Wire</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.SystemWireImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getSystemWire()
    * @generated
    */
   int        SYSTEM_WIRE                                    = 29;

   /**
    * The feature id for the '<em><b>Source Group</b></em>' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SYSTEM_WIRE__SOURCE_GROUP                      = 0;

   /**
    * The feature id for the '<em><b>Source</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SYSTEM_WIRE__SOURCE                            = 1;

   /**
    * The feature id for the '<em><b>Target Group</b></em>' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SYSTEM_WIRE__TARGET_GROUP                      = 2;

   /**
    * The feature id for the '<em><b>Target</b></em>' containment
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SYSTEM_WIRE__TARGET                            = 3;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SYSTEM_WIRE__ANY                               = 4;

   /**
    * The number of structural features of the the '<em>System Wire</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        SYSTEM_WIRE_FEATURE_COUNT                      = 5;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.UnknownImplementationImpl <em>Unknown Implementation</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.UnknownImplementationImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getUnknownImplementation()
    * @generated
    */
   int        UNKNOWN_IMPLEMENTATION                         = 30;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        UNKNOWN_IMPLEMENTATION__URI                    = IMPLEMENTATION_FEATURE_COUNT + 0;

   /**
    * The number of structural features of the the '<em>Unknown Implementation</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        UNKNOWN_IMPLEMENTATION_FEATURE_COUNT           = IMPLEMENTATION_FEATURE_COUNT + 1;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.WebServiceBindingImpl <em>Web Service Binding</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.WebServiceBindingImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getWebServiceBinding()
    * @generated
    */
   int        WEB_SERVICE_BINDING                            = 31;

   /**
    * The feature id for the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WEB_SERVICE_BINDING__URI                       = BINDING__URI;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WEB_SERVICE_BINDING__ANY                       = BINDING_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Port</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WEB_SERVICE_BINDING__PORT                      = BINDING_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WEB_SERVICE_BINDING__ANY_ATTRIBUTE             = BINDING_FEATURE_COUNT + 2;

   /**
    * The number of structural features of the the '<em>Web Service Binding</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WEB_SERVICE_BINDING_FEATURE_COUNT              = BINDING_FEATURE_COUNT + 3;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.impl.WSDLPortTypeImpl <em>WSDL Port Type</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.impl.WSDLPortTypeImpl
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getWSDLPortType()
    * @generated
    */
   int        WSDL_PORT_TYPE                                 = 32;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WSDL_PORT_TYPE__ANY                            = INTERFACE_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Callback Interface</b></em>'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WSDL_PORT_TYPE__CALLBACK_INTERFACE             = INTERFACE_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Interface</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WSDL_PORT_TYPE__INTERFACE                      = INTERFACE_FEATURE_COUNT + 2;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WSDL_PORT_TYPE__ANY_ATTRIBUTE                  = INTERFACE_FEATURE_COUNT + 3;

   /**
    * The number of structural features of the the '<em>WSDL Port Type</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int        WSDL_PORT_TYPE_FEATURE_COUNT                   = INTERFACE_FEATURE_COUNT + 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.sca.OverrideOptions <em>Override Options</em>}'
    * enum. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.OverrideOptions
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getOverrideOptions()
    * @generated
    */
   int        OVERRIDE_OPTIONS                               = 33;

   /**
    * The meta object id for the '<em>Multiplicity</em>' data type. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see java.lang.String
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getMultiplicity()
    * @generated
    */
   int        MULTIPLICITY                                   = 34;

   /**
    * The meta object id for the '<em>Override Options Object</em>' data
    * type. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.sca.OverrideOptions
    * @see org.eclipse.stp.core.sca.impl.SCAPackageImpl#getOverrideOptionsObject()
    * @generated
    */
   int        OVERRIDE_OPTIONS_OBJECT                        = 35;

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.AbstractImplementation <em>Abstract Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Abstract Implementation</em>'.
    * @see org.eclipse.stp.core.sca.AbstractImplementation
    * @generated
    */
   EClass getAbstractImplementation();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.AbstractImplementation#getComponentType <em>Component Type</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Component Type</em>'.
    * @see org.eclipse.stp.core.sca.AbstractImplementation#getComponentType()
    * @see #getAbstractImplementation()
    * @generated
    */
   EReference getAbstractImplementation_ComponentType();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.AbstractImplementation#getType <em>Type</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Type</em>'.
    * @see org.eclipse.stp.core.sca.AbstractImplementation#getType()
    * @see #getAbstractImplementation()
    * @generated
    */
   EAttribute getAbstractImplementation_Type();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Binding <em>Binding</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Binding</em>'.
    * @see org.eclipse.stp.core.sca.Binding
    * @generated
    */
   EClass getBinding();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Binding#getUri <em>Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Uri</em>'.
    * @see org.eclipse.stp.core.sca.Binding#getUri()
    * @see #getBinding()
    * @generated
    */
   EAttribute getBinding_Uri();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Component <em>Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Component</em>'.
    * @see org.eclipse.stp.core.sca.Component
    * @generated
    */
   EClass getComponent();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.Component#getPropertyValuesSet <em>Property Values Set</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Property Values Set</em>'.
    * @see org.eclipse.stp.core.sca.Component#getPropertyValuesSet()
    * @see #getComponent()
    * @generated
    */
   EReference getComponent_PropertyValuesSet();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.Component <em>Reference Values Set</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Reference Values Set</em>'.
    * @see org.eclipse.stp.core.sca.Component
    * @see #getComponent()
    * @generated
    */
   EReference getComponent_ReferenceValuesSet();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Component#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.Component#getName()
    * @see #getComponent()
    * @generated
    */
   EAttribute getComponent_Name();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ComponentType <em>Component Type</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Component Type</em>'.
    * @see org.eclipse.stp.core.sca.ComponentType
    * @generated
    */
   EClass getComponentType();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.ComponentType#getServices <em>Services</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Services</em>'.
    * @see org.eclipse.stp.core.sca.ComponentType#getServices()
    * @see #getComponentType()
    * @generated
    */
   EReference getComponentType_Services();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.ComponentType#getReferences <em>References</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>References</em>'.
    * @see org.eclipse.stp.core.sca.ComponentType#getReferences()
    * @see #getComponentType()
    * @generated
    */
   EReference getComponentType_References();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.ComponentType#getProperties <em>Properties</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Properties</em>'.
    * @see org.eclipse.stp.core.sca.ComponentType#getProperties()
    * @see #getComponentType()
    * @generated
    */
   EReference getComponentType_Properties();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ComponentType#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.ComponentType#getAny()
    * @see #getComponentType()
    * @generated
    */
   EAttribute getComponentType_Any();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ComponentType#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ComponentType#getAnyAttribute()
    * @see #getComponentType()
    * @generated
    */
   EAttribute getComponentType_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Composite <em>Composite</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Composite</em>'.
    * @see org.eclipse.stp.core.sca.Composite
    * @generated
    */
   EClass getComposite();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.Composite#getEntryPoints <em>Entry Points</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Entry Points</em>'.
    * @see org.eclipse.stp.core.sca.Composite#getEntryPoints()
    * @see #getComposite()
    * @generated
    */
   EReference getComposite_EntryPoints();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Composite <em>Components Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Components Group</em>'.
    * @see org.eclipse.stp.core.sca.Composite
    * @see #getComposite()
    * @generated
    */
   EAttribute getComposite_ComponentsGroup();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.Composite#getExternalServices <em>External Services</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>External Services</em>'.
    * @see org.eclipse.stp.core.sca.Composite#getExternalServices()
    * @see #getComposite()
    * @generated
    */
   EReference getComposite_ExternalServices();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.Composite <em>Components</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Components</em>'.
    * @see org.eclipse.stp.core.sca.Composite
    * @see #getComposite()
    * @generated
    */
   EReference getComposite_Components();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Composite#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.Composite#getName()
    * @see #getComposite()
    * @generated
    */
   EAttribute getComposite_Name();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.EntryPoint <em>Entry Point</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Entry Point</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint
    * @generated
    */
   EClass getEntryPoint();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.EntryPoint <em>Interface Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Interface Group</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_InterfaceGroup();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.EntryPoint <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint
    * @see #getEntryPoint()
    * @generated
    */
   EReference getEntryPoint_Interface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.EntryPoint <em>Binding Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Binding Group</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_BindingGroup();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.EntryPoint <em>Bindings</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Bindings</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint
    * @see #getEntryPoint()
    * @generated
    */
   EReference getEntryPoint_Bindings();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.EntryPoint#getReferenceTargets <em>Reference Targets</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Reference Targets</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint#getReferenceTargets()
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_ReferenceTargets();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.EntryPoint#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint#getAny()
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.EntryPoint#getMultiplicity <em>Multiplicity</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Multiplicity</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint#getMultiplicity()
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_Multiplicity();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.EntryPoint#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint#getName()
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_Name();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.EntryPoint#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.EntryPoint#getAnyAttribute()
    * @see #getEntryPoint()
    * @generated
    */
   EAttribute getEntryPoint_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ExternalService <em>External Service</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>External Service</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService
    * @generated
    */
   EClass getExternalService();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.ExternalService <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService
    * @see #getExternalService()
    * @generated
    */
   EReference getExternalService_Interface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ExternalService <em>Binding Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Binding Group</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService
    * @see #getExternalService()
    * @generated
    */
   EAttribute getExternalService_BindingGroup();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.ExternalService <em>Bindings</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Bindings</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService
    * @see #getExternalService()
    * @generated
    */
   EReference getExternalService_Bindings();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ExternalService <em>Interface Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Interface Group</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService
    * @see #getExternalService()
    * @generated
    */
   EAttribute getExternalService_InterfaceGroup();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ExternalService#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService#getAny()
    * @see #getExternalService()
    * @generated
    */
   EAttribute getExternalService_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ExternalService#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService#getName()
    * @see #getExternalService()
    * @generated
    */
   EAttribute getExternalService_Name();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ExternalService#getOverridable <em>Overridable</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Overridable</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService#getOverridable()
    * @see #getExternalService()
    * @generated
    */
   EAttribute getExternalService_Overridable();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ExternalService#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ExternalService#getAnyAttribute()
    * @see #getExternalService()
    * @generated
    */
   EAttribute getExternalService_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Implementation <em>Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Implementation</em>'.
    * @see org.eclipse.stp.core.sca.Implementation
    * @generated
    */
   EClass getImplementation();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ImplementationComponent <em>Implementation Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Implementation Component</em>'.
    * @see org.eclipse.stp.core.sca.ImplementationComponent
    * @generated
    */
   EClass getImplementationComponent();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ImplementationComponent <em>Implementation Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Implementation Group</em>'.
    * @see org.eclipse.stp.core.sca.ImplementationComponent
    * @see #getImplementationComponent()
    * @generated
    */
   EAttribute getImplementationComponent_ImplementationGroup();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.ImplementationComponent <em>Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Implementation</em>'.
    * @see org.eclipse.stp.core.sca.ImplementationComponent
    * @see #getImplementationComponent()
    * @generated
    */
   EReference getImplementationComponent_Implementation();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ImplementationComponent#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.ImplementationComponent#getAny()
    * @see #getImplementationComponent()
    * @generated
    */
   EAttribute getImplementationComponent_Any();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ImplementationComponent#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ImplementationComponent#getAnyAttribute()
    * @see #getImplementationComponent()
    * @generated
    */
   EAttribute getImplementationComponent_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Interface <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.Interface
    * @generated
    */
   EClass getInterface();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.JavaImplementation <em>Java Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Java Implementation</em>'.
    * @see org.eclipse.stp.core.sca.JavaImplementation
    * @generated
    */
   EClass getJavaImplementation();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.JavaImplementation#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.JavaImplementation#getAny()
    * @see #getJavaImplementation()
    * @generated
    */
   EAttribute getJavaImplementation_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.JavaImplementation#getClass_ <em>Class</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Class</em>'.
    * @see org.eclipse.stp.core.sca.JavaImplementation#getClass_()
    * @see #getJavaImplementation()
    * @generated
    */
   EAttribute getJavaImplementation_Class();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.JavaImplementation#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.JavaImplementation#getAnyAttribute()
    * @see #getJavaImplementation()
    * @generated
    */
   EAttribute getJavaImplementation_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.JavaInterface <em>Java Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Java Interface</em>'.
    * @see org.eclipse.stp.core.sca.JavaInterface
    * @generated
    */
   EClass getJavaInterface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.JavaInterface#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.JavaInterface#getAny()
    * @see #getJavaInterface()
    * @generated
    */
   EAttribute getJavaInterface_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.JavaInterface#getCallbackInterface <em>Callback Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Callback Interface</em>'.
    * @see org.eclipse.stp.core.sca.JavaInterface#getCallbackInterface()
    * @see #getJavaInterface()
    * @generated
    */
   EAttribute getJavaInterface_CallbackInterface();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.JavaInterface#getInterface <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.JavaInterface#getInterface()
    * @see #getJavaInterface()
    * @generated
    */
   EAttribute getJavaInterface_Interface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.JavaInterface#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.JavaInterface#getAnyAttribute()
    * @see #getJavaInterface()
    * @generated
    */
   EAttribute getJavaInterface_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Module <em>Module</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Module</em>'.
    * @see org.eclipse.stp.core.sca.Module
    * @generated
    */
   EClass getModule();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ModuleComponent <em>Module Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Module Component</em>'.
    * @see org.eclipse.stp.core.sca.ModuleComponent
    * @generated
    */
   EClass getModuleComponent();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ModuleComponent#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.ModuleComponent#getAny()
    * @see #getModuleComponent()
    * @generated
    */
   EAttribute getModuleComponent_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ModuleComponent#getModule <em>Module</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Module</em>'.
    * @see org.eclipse.stp.core.sca.ModuleComponent#getModule()
    * @see #getModuleComponent()
    * @generated
    */
   EAttribute getModuleComponent_Module();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ModuleComponent#getUri <em>Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Uri</em>'.
    * @see org.eclipse.stp.core.sca.ModuleComponent#getUri()
    * @see #getModuleComponent()
    * @generated
    */
   EAttribute getModuleComponent_Uri();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ModuleComponent#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ModuleComponent#getAnyAttribute()
    * @see #getModuleComponent()
    * @generated
    */
   EAttribute getModuleComponent_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ModuleFragment <em>Module Fragment</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Module Fragment</em>'.
    * @see org.eclipse.stp.core.sca.ModuleFragment
    * @generated
    */
   EClass getModuleFragment();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.ModuleFragment#getWires <em>Wires</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Wires</em>'.
    * @see org.eclipse.stp.core.sca.ModuleFragment#getWires()
    * @see #getModuleFragment()
    * @generated
    */
   EReference getModuleFragment_Wires();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ModuleFragment#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.ModuleFragment#getAny()
    * @see #getModuleFragment()
    * @generated
    */
   EAttribute getModuleFragment_Any();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ModuleFragment#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ModuleFragment#getAnyAttribute()
    * @see #getModuleFragment()
    * @generated
    */
   EAttribute getModuleFragment_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ModuleReference <em>Module Reference</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Module Reference</em>'.
    * @see org.eclipse.stp.core.sca.ModuleReference
    * @generated
    */
   EClass getModuleReference();

   /**
    * Returns the meta object for the reference '{@link org.eclipse.stp.core.sca.ModuleReference#getExternalService <em>External Service</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the reference '<em>External Service</em>'.
    * @see org.eclipse.stp.core.sca.ModuleReference#getExternalService()
    * @see #getModuleReference()
    * @generated
    */
   EReference getModuleReference_ExternalService();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ModuleService <em>Module Service</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Module Service</em>'.
    * @see org.eclipse.stp.core.sca.ModuleService
    * @generated
    */
   EClass getModuleService();

   /**
    * Returns the meta object for the reference '{@link org.eclipse.stp.core.sca.ModuleService#getEntryPoint <em>Entry Point</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the reference '<em>Entry Point</em>'.
    * @see org.eclipse.stp.core.sca.ModuleService#getEntryPoint()
    * @see #getModuleService()
    * @generated
    */
   EReference getModuleService_EntryPoint();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ModuleWire <em>Module Wire</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Module Wire</em>'.
    * @see org.eclipse.stp.core.sca.ModuleWire
    * @generated
    */
   EClass getModuleWire();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ModuleWire#getSourceUri <em>Source Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Source Uri</em>'.
    * @see org.eclipse.stp.core.sca.ModuleWire#getSourceUri()
    * @see #getModuleWire()
    * @generated
    */
   EAttribute getModuleWire_SourceUri();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ModuleWire#getTargetUri <em>Target Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Target Uri</em>'.
    * @see org.eclipse.stp.core.sca.ModuleWire#getTargetUri()
    * @see #getModuleWire()
    * @generated
    */
   EAttribute getModuleWire_TargetUri();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ModuleWire#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.ModuleWire#getAny()
    * @see #getModuleWire()
    * @generated
    */
   EAttribute getModuleWire_Any();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ModuleWire#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ModuleWire#getAnyAttribute()
    * @see #getModuleWire()
    * @generated
    */
   EAttribute getModuleWire_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Property <em>Property</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Property</em>'.
    * @see org.eclipse.stp.core.sca.Property
    * @generated
    */
   EClass getProperty();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Property#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.Property#getAny()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Property#getDefault <em>Default</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Default</em>'.
    * @see org.eclipse.stp.core.sca.Property#getDefault()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_Default();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Property#isMany <em>Many</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Many</em>'.
    * @see org.eclipse.stp.core.sca.Property#isMany()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_Many();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Property#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.Property#getName()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_Name();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Property#isRequired <em>Required</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Required</em>'.
    * @see org.eclipse.stp.core.sca.Property#isRequired()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_Required();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Property#getType <em>Type</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Type</em>'.
    * @see org.eclipse.stp.core.sca.Property#getType()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_Type();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Property#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.Property#getAnyAttribute()
    * @see #getProperty()
    * @generated
    */
   EAttribute getProperty_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.PropertyValue <em>Property Value</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Property Value</em>'.
    * @see org.eclipse.stp.core.sca.PropertyValue
    * @generated
    */
   EClass getPropertyValue();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.PropertyValue#getValue <em>Value</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Value</em>'.
    * @see org.eclipse.stp.core.sca.PropertyValue#getValue()
    * @see #getPropertyValue()
    * @generated
    */
   EAttribute getPropertyValue_Value();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.PropertyValue#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.PropertyValue#getName()
    * @see #getPropertyValue()
    * @generated
    */
   EAttribute getPropertyValue_Name();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.PropertyValuesSet <em>Property Values Set</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Property Values Set</em>'.
    * @see org.eclipse.stp.core.sca.PropertyValuesSet
    * @generated
    */
   EClass getPropertyValuesSet();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.PropertyValuesSet#getPropertyValues <em>Property Values</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Property Values</em>'.
    * @see org.eclipse.stp.core.sca.PropertyValuesSet#getPropertyValues()
    * @see #getPropertyValuesSet()
    * @generated
    */
   EReference getPropertyValuesSet_PropertyValues();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.PropertyValuesSet#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.PropertyValuesSet#getAnyAttribute()
    * @see #getPropertyValuesSet()
    * @generated
    */
   EAttribute getPropertyValuesSet_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Reference <em>Reference</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Reference</em>'.
    * @see org.eclipse.stp.core.sca.Reference
    * @generated
    */
   EClass getReference();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Reference <em>Interface Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Interface Group</em>'.
    * @see org.eclipse.stp.core.sca.Reference
    * @see #getReference()
    * @generated
    */
   EAttribute getReference_InterfaceGroup();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.Reference <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.Reference
    * @see #getReference()
    * @generated
    */
   EReference getReference_Interface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Reference#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.Reference#getAny()
    * @see #getReference()
    * @generated
    */
   EAttribute getReference_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Reference#getMultiplicity <em>Multiplicity</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Multiplicity</em>'.
    * @see org.eclipse.stp.core.sca.Reference#getMultiplicity()
    * @see #getReference()
    * @generated
    */
   EAttribute getReference_Multiplicity();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Reference#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.Reference#getName()
    * @see #getReference()
    * @generated
    */
   EAttribute getReference_Name();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Reference#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.Reference#getAnyAttribute()
    * @see #getReference()
    * @generated
    */
   EAttribute getReference_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ReferenceValue <em>Reference Value</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Reference Value</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValue
    * @generated
    */
   EClass getReferenceValue();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ReferenceValue#getTargetURI <em>Target URI</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Target URI</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValue#getTargetURI()
    * @see #getReferenceValue()
    * @generated
    */
   EAttribute getReferenceValue_TargetURI();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.ReferenceValue#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValue#getName()
    * @see #getReferenceValue()
    * @generated
    */
   EAttribute getReferenceValue_Name();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ReferenceValue#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValue#getAnyAttribute()
    * @see #getReferenceValue()
    * @generated
    */
   EAttribute getReferenceValue_AnyAttribute();

   /**
    * Returns the meta object for the container reference '{@link org.eclipse.stp.core.sca.ReferenceValue#getReferenceValueSet <em>Reference Value Set</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the container reference '<em>Reference Value Set</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValue#getReferenceValueSet()
    * @see #getReferenceValue()
    * @generated
    */
   EReference getReferenceValue_ReferenceValueSet();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.ReferenceValuesSet <em>Reference Values Set</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Reference Values Set</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValuesSet
    * @generated
    */
   EClass getReferenceValuesSet();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getReferenceValues <em>Reference Values</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Reference Values</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValuesSet#getReferenceValues()
    * @see #getReferenceValuesSet()
    * @generated
    */
   EReference getReferenceValuesSet_ReferenceValues();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValuesSet#getAnyAttribute()
    * @see #getReferenceValuesSet()
    * @generated
    */
   EAttribute getReferenceValuesSet_AnyAttribute();

   /**
    * Returns the meta object for the container reference '{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getComponent <em>Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the container reference '<em>Component</em>'.
    * @see org.eclipse.stp.core.sca.ReferenceValuesSet#getComponent()
    * @see #getReferenceValuesSet()
    * @generated
    */
   EReference getReferenceValuesSet_Component();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.SCABinding <em>Binding</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Binding</em>'.
    * @see org.eclipse.stp.core.sca.SCABinding
    * @generated
    */
   EClass getSCABinding();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.SCABinding#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.SCABinding#getAny()
    * @see #getSCABinding()
    * @generated
    */
   EAttribute getSCABinding_Any();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.SCABinding#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.SCABinding#getAnyAttribute()
    * @see #getSCABinding()
    * @generated
    */
   EAttribute getSCABinding_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.SCACoreRoot <em>Core Root</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Core Root</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot
    * @generated
    */
   EClass getSCACoreRoot();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.SCACoreRoot#getMixed <em>Mixed</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Mixed</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getMixed()
    * @see #getSCACoreRoot()
    * @generated
    */
   EAttribute getSCACoreRoot_Mixed();

   /**
    * Returns the meta object for the map '{@link org.eclipse.stp.core.sca.SCACoreRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the map '<em>XMLNS Prefix Map</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getXMLNSPrefixMap()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_XMLNSPrefixMap();

   /**
    * Returns the meta object for the map '{@link org.eclipse.stp.core.sca.SCACoreRoot#getXSISchemaLocation <em>XSI Schema Location</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the map '<em>XSI Schema Location</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getXSISchemaLocation()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_XSISchemaLocation();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getAbstractComponent <em>Abstract Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Abstract Component</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getAbstractComponent()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_AbstractComponent();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBinding <em>Binding</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Binding</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getBinding()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Binding();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingSca <em>Binding Sca</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Binding Sca</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getBindingSca()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_BindingSca();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getComponent <em>Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Component</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getComponent()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Component();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getComponentType <em>Component Type</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Component Type</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getComponentType()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_ComponentType();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getComposite <em>Composite</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Composite</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getComposite()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Composite();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementation <em>Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Implementation</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getImplementation()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Implementation();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationAbstract <em>Implementation Abstract</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Implementation Abstract</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getImplementationAbstract()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_ImplementationAbstract();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationUnknown <em>Implementation Unknown</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Implementation Unknown</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getImplementationUnknown()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_ImplementationUnknown();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterface <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getInterface()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Interface();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getModule <em>Module</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Module</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getModule()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Module();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getModuleComponent <em>Module Component</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Module Component</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getModuleComponent()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_ModuleComponent();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getModuleFragment <em>Module Fragment</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Module Fragment</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getModuleFragment()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_ModuleFragment();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSource <em>Source</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Source</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getSource()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Source();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSourceEpr <em>Source Epr</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Source Epr</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getSourceEpr()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_SourceEpr();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSourceUri <em>Source Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Source Uri</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getSourceUri()
    * @see #getSCACoreRoot()
    * @generated
    */
   EAttribute getSCACoreRoot_SourceUri();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getSubsystem <em>Subsystem</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Subsystem</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getSubsystem()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Subsystem();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getTarget <em>Target</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Target</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getTarget()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_Target();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getTargetEpr <em>Target Epr</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Target Epr</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getTargetEpr()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_TargetEpr();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.SCACoreRoot#getTargetUri <em>Target Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Target Uri</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getTargetUri()
    * @see #getSCACoreRoot()
    * @generated
    */
   EAttribute getSCACoreRoot_TargetUri();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceWsdl <em>Interface Wsdl</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface Wsdl</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceWsdl()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_InterfaceWsdl();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceJava <em>Interface Java</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface Java</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getInterfaceJava()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_InterfaceJava();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingWs <em>Binding Ws</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Binding Ws</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getBindingWs()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_BindingWs();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getImplementationJava <em>Implementation Java</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Implementation Java</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getImplementationJava()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_ImplementationJava();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SCACoreRoot#getBindingEjb <em>Binding Ejb</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Binding Ejb</em>'.
    * @see org.eclipse.stp.core.sca.SCACoreRoot#getBindingEjb()
    * @see #getSCACoreRoot()
    * @generated
    */
   EReference getSCACoreRoot_BindingEjb();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Service <em>Service</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Service</em>'.
    * @see org.eclipse.stp.core.sca.Service
    * @generated
    */
   EClass getService();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Service <em>Interface Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Interface Group</em>'.
    * @see org.eclipse.stp.core.sca.Service
    * @see #getService()
    * @generated
    */
   EAttribute getService_InterfaceGroup();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.Service <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.Service
    * @see #getService()
    * @generated
    */
   EReference getService_Interface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Service#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.Service#getAny()
    * @see #getService()
    * @generated
    */
   EAttribute getService_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Service#getName <em>Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Name</em>'.
    * @see org.eclipse.stp.core.sca.Service#getName()
    * @see #getService()
    * @generated
    */
   EAttribute getService_Name();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Service#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.Service#getAnyAttribute()
    * @see #getService()
    * @generated
    */
   EAttribute getService_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.SLSBBinding <em>SLSB Binding</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>SLSB Binding</em>'.
    * @see org.eclipse.stp.core.sca.SLSBBinding
    * @generated
    */
   EClass getSLSBBinding();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.SLSBBinding#getJndiName <em>Jndi Name</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Jndi Name</em>'.
    * @see org.eclipse.stp.core.sca.SLSBBinding#getJndiName()
    * @see #getSLSBBinding()
    * @generated
    */
   EAttribute getSLSBBinding_JndiName();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.Subsystem <em>Subsystem</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Subsystem</em>'.
    * @see org.eclipse.stp.core.sca.Subsystem
    * @generated
    */
   EClass getSubsystem();

   /**
    * Returns the meta object for the containment reference list '{@link org.eclipse.stp.core.sca.Subsystem#getWires <em>Wires</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference list '<em>Wires</em>'.
    * @see org.eclipse.stp.core.sca.Subsystem#getWires()
    * @see #getSubsystem()
    * @generated
    */
   EReference getSubsystem_Wires();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Subsystem#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.Subsystem#getAny()
    * @see #getSubsystem()
    * @generated
    */
   EAttribute getSubsystem_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.Subsystem#getUri <em>Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Uri</em>'.
    * @see org.eclipse.stp.core.sca.Subsystem#getUri()
    * @see #getSubsystem()
    * @generated
    */
   EAttribute getSubsystem_Uri();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.Subsystem#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.Subsystem#getAnyAttribute()
    * @see #getSubsystem()
    * @generated
    */
   EAttribute getSubsystem_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.SystemWire <em>System Wire</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>System Wire</em>'.
    * @see org.eclipse.stp.core.sca.SystemWire
    * @generated
    */
   EClass getSystemWire();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.SystemWire#getSourceGroup <em>Source Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Source Group</em>'.
    * @see org.eclipse.stp.core.sca.SystemWire#getSourceGroup()
    * @see #getSystemWire()
    * @generated
    */
   EAttribute getSystemWire_SourceGroup();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SystemWire#getSource <em>Source</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Source</em>'.
    * @see org.eclipse.stp.core.sca.SystemWire#getSource()
    * @see #getSystemWire()
    * @generated
    */
   EReference getSystemWire_Source();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.SystemWire#getTargetGroup <em>Target Group</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Target Group</em>'.
    * @see org.eclipse.stp.core.sca.SystemWire#getTargetGroup()
    * @see #getSystemWire()
    * @generated
    */
   EAttribute getSystemWire_TargetGroup();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.sca.SystemWire#getTarget <em>Target</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Target</em>'.
    * @see org.eclipse.stp.core.sca.SystemWire#getTarget()
    * @see #getSystemWire()
    * @generated
    */
   EReference getSystemWire_Target();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.SystemWire#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.SystemWire#getAny()
    * @see #getSystemWire()
    * @generated
    */
   EAttribute getSystemWire_Any();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.UnknownImplementation <em>Unknown Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Unknown Implementation</em>'.
    * @see org.eclipse.stp.core.sca.UnknownImplementation
    * @generated
    */
   EClass getUnknownImplementation();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.UnknownImplementation#getUri <em>Uri</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Uri</em>'.
    * @see org.eclipse.stp.core.sca.UnknownImplementation#getUri()
    * @see #getUnknownImplementation()
    * @generated
    */
   EAttribute getUnknownImplementation_Uri();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.WebServiceBinding <em>Web Service Binding</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Web Service Binding</em>'.
    * @see org.eclipse.stp.core.sca.WebServiceBinding
    * @generated
    */
   EClass getWebServiceBinding();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.WebServiceBinding#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.WebServiceBinding#getAny()
    * @see #getWebServiceBinding()
    * @generated
    */
   EAttribute getWebServiceBinding_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.WebServiceBinding#getPort <em>Port</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Port</em>'.
    * @see org.eclipse.stp.core.sca.WebServiceBinding#getPort()
    * @see #getWebServiceBinding()
    * @generated
    */
   EAttribute getWebServiceBinding_Port();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.WebServiceBinding#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.WebServiceBinding#getAnyAttribute()
    * @see #getWebServiceBinding()
    * @generated
    */
   EAttribute getWebServiceBinding_AnyAttribute();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.sca.WSDLPortType <em>WSDL Port Type</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>WSDL Port Type</em>'.
    * @see org.eclipse.stp.core.sca.WSDLPortType
    * @generated
    */
   EClass getWSDLPortType();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.WSDLPortType#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.sca.WSDLPortType#getAny()
    * @see #getWSDLPortType()
    * @generated
    */
   EAttribute getWSDLPortType_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.WSDLPortType#getCallbackInterface <em>Callback Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Callback Interface</em>'.
    * @see org.eclipse.stp.core.sca.WSDLPortType#getCallbackInterface()
    * @see #getWSDLPortType()
    * @generated
    */
   EAttribute getWSDLPortType_CallbackInterface();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.sca.WSDLPortType#getInterface <em>Interface</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Interface</em>'.
    * @see org.eclipse.stp.core.sca.WSDLPortType#getInterface()
    * @see #getWSDLPortType()
    * @generated
    */
   EAttribute getWSDLPortType_Interface();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.sca.WSDLPortType#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.sca.WSDLPortType#getAnyAttribute()
    * @see #getWSDLPortType()
    * @generated
    */
   EAttribute getWSDLPortType_AnyAttribute();

   /**
    * Returns the meta object for enum '{@link org.eclipse.stp.core.sca.OverrideOptions <em>Override Options</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for enum '<em>Override Options</em>'.
    * @see org.eclipse.stp.core.sca.OverrideOptions
    * @generated
    */
   EEnum getOverrideOptions();

   /**
    * Returns the meta object for data type '{@link java.lang.String <em>Multiplicity</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for data type '<em>Multiplicity</em>'.
    * @see java.lang.String
    * @model instanceClass="java.lang.String"
    *        extendedMetaData="name='Multiplicity'
    *        baseType='http://www.eclipse.org/emf/2003/XMLType#string'
    *        enumeration='0..1 1..1 0..n 1..n'"
    * @generated
    */
   EDataType getMultiplicity();

   /**
    * Returns the meta object for data type '{@link org.eclipse.stp.core.sca.OverrideOptions <em>Override Options Object</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for data type '<em>Override Options Object</em>'.
    * @see org.eclipse.stp.core.sca.OverrideOptions
    * @model instanceClass="org.eclipse.stp.core.sca.OverrideOptions"
    *        extendedMetaData="name='OverrideOptions:Object'
    *        baseType='OverrideOptions'"
    * @generated
    */
   EDataType getOverrideOptionsObject();

   /**
    * Returns the factory that creates the instances of the model. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the factory that creates the instances of the model.
    * @generated
    */
   SCAFactory getSCAFactory();

} // SCAPackage
