/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>System Wire</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.SystemWire#getSourceGroup <em>Source Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SystemWire#getSource <em>Source</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SystemWire#getTargetGroup <em>Target Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SystemWire#getTarget <em>Target</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.SystemWire#getAny <em>Any</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getSystemWire()
 * @model extendedMetaData="name='SystemWire' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface SystemWire extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Source Group</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Source Group</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Source Group</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSystemWire_SourceGroup()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        required="true" extendedMetaData="kind='group' name='source:group'
    *        namespace='##targetNamespace'"
    * @generated
    */
   FeatureMap getSourceGroup();

   /**
    * Returns the value of the '<em><b>Source</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Source</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Source</em>' containment reference.
    * @see #setSource(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSystemWire_Source()
    * @model containment="true" resolveProxies="false" required="true"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='source'
    *        namespace='##targetNamespace' group='source:group'"
    * @generated
    */
   Object getSource();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SystemWire#getSource <em>Source</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Source</em>' containment
    *           reference.
    * @see #getSource()
    * @generated
    */
   void setSource(Object value);

   /**
    * Returns the value of the '<em><b>Target Group</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Target Group</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Target Group</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSystemWire_TargetGroup()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        required="true" extendedMetaData="kind='group' name='target:group'
    *        namespace='##targetNamespace'"
    * @generated
    */
   FeatureMap getTargetGroup();

   /**
    * Returns the value of the '<em><b>Target</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Target</em>' containment reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Target</em>' containment reference.
    * @see #setTarget(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSystemWire_Target()
    * @model containment="true" resolveProxies="false" required="true"
    *        transient="true" volatile="true" derived="true"
    *        extendedMetaData="kind='element' name='target'
    *        namespace='##targetNamespace' group='target:group'"
    * @generated
    */
   Object getTarget();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.SystemWire#getTarget <em>Target</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Target</em>' containment
    *           reference.
    * @see #getTarget()
    * @generated
    */
   void setTarget(Object value);

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSystemWire_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':4' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

} // SystemWire
