/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.resources.ComponentTypeScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.SCACoreRoot;

public class ComponentTypeArtifactEdit {

   private IEditModelScribbler          scribbler;

   private ComponentTypeScribblerDomain domain;

   public ComponentTypeArtifactEdit(ComponentTypeScribblerDomain aDomain,
         boolean toMakeReadOnly) throws EditModelException {

      Assert.isNotNull(aDomain);
      if (toMakeReadOnly)
         scribbler = aDomain.createScribblerForRead();
      else
         scribbler = aDomain.createScribblerForWrite();
      domain = aDomain;
   }

   public ComponentType getComponentType() {
      Resource resource = scribbler.getResource(domain
            .getComponentTypeDescriptor());
      Assert.isTrue(resource.getContents().get(0) instanceof SCACoreRoot);
      SCACoreRoot root = (SCACoreRoot) resource.getContents().get(0);
      return root.getComponentType();
   }

   public void save(boolean force, IProgressMonitor monitor)
         throws EditModelException {
      scribbler.save(force, monitor);
   }

   public void discard(IProgressMonitor monitor) throws EditModelException {
      scribbler.discard(monitor);
   }

   public void close(IProgressMonitor monitor) throws EditModelException {
      scribbler.close(monitor);
   }

}
