/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.edit.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ChangePropertyOperation extends AbstractScribblerOperation {
   private String  oldName         = null;

   private String  newName         = null;

   private Object  oldType         = null;

   private Object  newType         = null;

   private String  oldDefaultValue = null;

   private String  newDefaultValue = null;

   private boolean newisMany;

   private boolean oldisMany;

   private boolean newisRequired;

   private boolean oldisRequired;

   public ChangePropertyOperation() {
      super();
   }

   public ChangePropertyOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {
      Property property = (Property) model
            .getProperty(IChangePropertyDataModelProperties.PROPERTY);
      Assert.isNotNull(property);

      oldName = property.getName();
      oldType = property.getType();
      oldDefaultValue = property.getDefault();
      oldisMany = property.isMany();
      oldisRequired = property.isRequired();

      newName = model
            .getStringProperty(IChangePropertyDataModelProperties.NEW_NAME);
      newType = model.getProperty(IChangePropertyDataModelProperties.NEW_TYPE);
      newDefaultValue = model
            .getStringProperty(IChangePropertyDataModelProperties.NEW_DEFAULT_VALUE);
      newisMany = model
            .getBooleanProperty(IChangePropertyDataModelProperties.NEW_MANY);
      newisRequired = model
            .getBooleanProperty(IChangePropertyDataModelProperties.NEW_REQUIRED);

      if (newName != null && !newName.equals(oldName))
         property.setName(newName);

      if (newType != null && !newType.equals(oldType))
         property.setType(newType);

      if (newDefaultValue != null && !newDefaultValue.equals(oldDefaultValue))
         property.setDefault(newDefaultValue);

      if (newisMany != oldisMany)
         property.setMany(newisMany);

      if (newisRequired != oldisRequired)
         property.setRequired(newisRequired);

      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      Property property = (Property) model
            .getProperty(IChangePropertyDataModelProperties.PROPERTY);
      property.setName(newName);
      property.setType(newType);
      property.setDefault(newDefaultValue);
      property.setMany(newisMany);
      property.setRequired(newisRequired);

      return OK_STATUS;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      Property property = (Property) model
            .getProperty(IChangePropertyDataModelProperties.PROPERTY);
      property.setName(oldName);
      property.setType(oldType);
      property.setDefault(oldDefaultValue);
      property.setMany(oldisMany);
      property.setRequired(oldisRequired);

      return OK_STATUS;
   }

}
