/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.edit.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

/**
 * @since 1.0
 * 
 */
public interface IChangePropertyDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] Component who owns this property/s.
    * 
    * Type = {@link org.eclipse.stp.core.sca.ComponentType}
    */
   public static final String PROPERTY          = "IChangePropertyDataModelProperties.PROPERTY";         //$NON-NLS-1$

   /**
    * [OPTIONAL] Default value of the property.
    * 
    * Type = {@link String}
    * 
    */
   public static final String NEW_DEFAULT_VALUE = "IChangePropertyDataModelProperties.NEW_DEFAULT_VALUE"; //$NON-NLS-1$

   /**
    * [OPTIONAL] Name of the property
    * 
    * Type = {@link String}
    */
   public static final String NEW_NAME          = "IChangePropertyDataModelProperties.NEW_NAME";         //$NON-NLS-1$

   /**
    * [OPTIONAL] Type of the property. Use XMLTypeUtil to construct it.
    * 
    * Type = {@link org.eclipse.emf.ecore.xml.type.internal.QName}
    */
   public static final String NEW_TYPE          = "IChangePropertyDataModelProperties.NEW_TYPE";         //$NON-NLS-1$

   /**
    * [OPTIONAL] isMany
    * 
    * Type = {@link Boolean}
    */
   public static final String NEW_MANY          = "IChangePropertyDataModelProperties.NEW_MANY";         //$NON-NLS-1$

   /**
    * [OPTIONAL] isRequired
    * 
    * Type = {@link Boolean}
    */
   public static final String NEW_REQUIRED      = "IChangePropertyDataModelProperties.NEW_REQUIRED";     //$NON-NLS-1$

}
