/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.edit.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

/**
 * @since 1.0
 * 
 */
public interface IChangeSCAObjectNameDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] SCA_OBJECT whose name is going to be renamed.
    * 
    * SCAOBJECT = {@link org.eclipse.stp.core.sca.SCAObject}
    */
   public static final String SCAOBJECT           = "IChangeSCAObjectNameDataModelProperties.SCAOBJECT";          //$NON-NLS-1$

   /**
    * [REQUIRED] New name of the SCAObject.
    * 
    * NEW_NAME = {@link String}
    */
   public static final String NEW_NAME            = "IChangeSCAObjectNameDataModelProperties.NEW_NAME";           //$NON-NLS-1$	

   /**
    * [OPTIONAL] List for Duplicate Check
    * 
    * SCAOBJECT_LIST = {@link java.util.List}
    */
   public static final String EXISTING_SCAOBJECTS = "IChangeSCAObjectNameDataModelProperties.EXISTING_SCAOBJECTS"; //$NON-NLS-1$	

}
