/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.stp.core.infrastructure.emf.IEMFWorkbenchContextFactory;
import org.eclipse.stp.core.internal.introspection.ComponentTypeResourceAssistantFactory;
import org.osgi.framework.BundleContext;

public class STPCorePlugin extends EMFPlugin {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String        copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The plugin id.
    */
   public static String              PLUGIN_ID = "org.eclipse.stp.core";                                                                               //$NON-NLS-1$

   /**
    * Keep track of the singleton. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final STPCorePlugin INSTANCE  = new STPCorePlugin();

   /**
    * Keep track of the singleton. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private static Implementation     plugin;

   public STPCorePlugin() {
      super(new ResourceLocator[] {});
   }

   /**
    * Returns the singleton instance of the Eclipse plugin. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return the singleton instance.
    * @generated
    */
   public ResourceLocator getPluginResourceLocator() {
      return plugin;
   }

   /**
    * Returns the singleton instance of the Eclipse plugin. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return the singleton instance.
    * @generated
    */
   public static Implementation getPlugin() {
      return plugin;
   }

   /**
    * The actual implementation of the Eclipse <b>Plugin</b>. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    */
   public static class Implementation extends EclipsePlugin {
      /**
       * Creates an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
       * 
       * @generated
       */
      public Implementation() {
         super();

         // Remember the static instance.
         //
         plugin = this;
      }

      public void start(BundleContext context) throws Exception {
         super.start(context);
         IEMFWorkbenchContextFactory.eINSTANCE
               .installResourceAssistantFactory(ComponentTypeResourceAssistantFactory
                     .getInstance());
      }
   }

   public static void logError(int aCode, String aMessage, Throwable anException) {
      log(createErrorStatus(aCode, aMessage, anException));
   }

   public static void log(int severity, int aCode, String aMessage,
         Throwable exception) {
      log(createStatus(severity, aCode, aMessage, exception));
   }

   public static void log(IStatus aStatus) {
      getPlugin().getLog().log(aStatus);
   }

   public static IStatus createStatus(int severity, int aCode, String aMessage,
         Throwable exception) {
      return new Status(severity, PLUGIN_ID, aCode, aMessage, exception);
   }

   public static IStatus createErrorStatus(int aCode, String aMessage,
         Throwable exception) {
      return createStatus(IStatus.ERROR, aCode, aMessage, exception);
   }

   public static IStatus createErrorStatus(String aMessage, Throwable exception) {
      return createStatus(IStatus.ERROR, 0, aMessage, exception);
   }
}
