/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection.query;

import java.util.List;
import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.core.sca.SCAObject;

public interface IModelQuery {

   void addChildQuery(IModelQuery aMoreSpecificQuery);

   Set getChildren();

   List matches(List theSearchSet);

   boolean matches(EObject theObject);

   boolean applyDelta(EObject anObject);

   void removeUntouched(SCAObject anObject, EStructuralFeature feature);

   int getType();
}
