/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.introspection;

import org.eclipse.stp.core.internal.introspection.IntrospectionRecorder;

/**
 * Create a dynamic model introspector.
 * 
 * @since 1.0
 * 
 */
public class DynamicModelIntrospectorFactory {

   /**
    * The singleton instance.
    */
   public static final DynamicModelIntrospectorFactory INSTANCE = new DynamicModelIntrospectorFactory();

   protected DynamicModelIntrospectorFactory() {

   }

   /**
    * 
    * @return A Dynamic Introspector
    */
   public IDynamicModelIntrospector createDynamicIntrospector() {
      return new IntrospectionRecorder();
   }

}
