/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.List;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Component Type</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.ComponentType#getServices <em>Services</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ComponentType#getReferences <em>References</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ComponentType#getProperties <em>Properties</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ComponentType#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ComponentType#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getComponentType()
 * @model extendedMetaData="name='ComponentType' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface ComponentType extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Services</b></em>' containment
    * reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.Service}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Services</em>' containment reference list
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Services</em>' containment reference
    *         list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponentType_Services()
    * @model type="org.eclipse.stp.core.sca.Service" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='service'"
    * @generated
    */
   List getServices();

   /**
    * Returns the value of the '<em><b>References</b></em>' containment
    * reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.Reference}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>References</em>' containment reference list
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>References</em>' containment reference
    *         list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponentType_References()
    * @model type="org.eclipse.stp.core.sca.Reference" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='reference'"
    * @generated
    */
   List getReferences();

   /**
    * Returns the value of the '<em><b>Properties</b></em>' containment
    * reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.Property}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Properties</em>' containment reference list
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Properties</em>' containment reference
    *         list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponentType_Properties()
    * @model type="org.eclipse.stp.core.sca.Property" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='property'"
    * @generated
    */
   List getProperties();

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponentType_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':3' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponentType_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':4' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

   /**
    * @return A resolved implementation. The client is responsible for
    *         determining the return type.
    */
   Object resolveImplementation();

   /**
    * Return a {@link Reference} with a name matching name.
    * 
    * @param referenceName
    *           The name of the reference to search for.
    * @return Reference
    */
   Reference getReference(String referenceName);

   /**
    * Return a {@link Service} with a name matching name;
    * 
    * @param serviceName
    *           The name of the service to search for
    * @return Service
    */
   Service getService(String serviceName);

   /**
    * Return a {@link Service} with an Interface matching interfaze;
    * 
    * @param interfaze
    *           The interfaze of the service to search for
    * @return Service
    */
   public Service getService(Interface interfaze);

   /**
    * Return a {@link Property} with a name matching propertyName
    * 
    * @param propertyName
    *           The name of the property to search for
    * @return The property with the given name
    */
   Property getProperty(String propertyName);

} // ComponentType
