/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.Collection;
import java.util.List;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Composite</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.Composite#getEntryPoints <em>Entry Points</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Composite#getExternalServices <em>External Services</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Composite#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getComposite()
 * @model features="componentsGroup components"
 *        componentsGroupType="org.eclipse.emf.ecore.util.FeatureMap$Entry"
 *        componentsGroupUnique="false"
 *        componentsGroupDataType="org.eclipse.emf.ecore.EFeatureMapEntry"
 *        componentsGroupMany="true"
 *        componentsGroupSuppressedGetVisibility="true"
 *        componentsGroupSuppressedSetVisibility="true"
 *        componentsGroupExtendedMetaData="kind='group'
 *        name='abstractComponent:group' namespace='##targetNamespace'"
 *        componentsType="org.eclipse.stp.core.sca.Component"
 *        componentsContainment="true" componentsResolveProxies="false"
 *        componentsMany="true" componentsTransient="true"
 *        componentsVolatile="true" componentsDerived="true"
 *        componentsSuppressedGetVisibility="true"
 *        componentsSuppressedSetVisibility="true"
 *        componentsExtendedMetaData="kind='element' name='abstractComponent'
 *        namespace='##targetNamespace' group='abstractComponent:group'"
 *        extendedMetaData="name='Composite' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface Composite extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Entry Points</b></em>' containment
    * reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.EntryPoint}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Entry Points</em>' containment reference
    * list isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Entry Points</em>' containment reference
    *         list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComposite_EntryPoints()
    * @model type="org.eclipse.stp.core.sca.EntryPoint" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='entryPoint'"
    * @generated
    */
   List getEntryPoints();

   /**
    * Returns the value of the '<em><b>External Services</b></em>'
    * containment reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.ExternalService}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>External Services</em>' containment
    * reference list isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>External Services</em>' containment
    *         reference list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComposite_ExternalServices()
    * @model type="org.eclipse.stp.core.sca.ExternalService" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='externalService'"
    * @generated
    */
   List getExternalServices();

   /**
    * Returns the value of the '<em><b>Components</b></em>' containment
    * reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.Component}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Components</em>' containment reference list
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Components</em>' containment reference
    *         list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getComposite_Components()
    * @model type="org.eclipse.stp.core.sca.Component" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='component'"
    */
   List getComponents();

   /**
    * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Name</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Name</em>' attribute.
    * @see #setName(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getComposite_Name()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        required="true" extendedMetaData="kind='attribute' name='name'"
    * @generated
    */
   String getName();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Composite#getName <em>Name</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Name</em>' attribute.
    * @see #getName()
    * @generated
    */
   void setName(String value);

   /**
    * 
    * @param wireSource
    *           A non-null WireSource (generally one of 'EntryPoint' or
    *           'ReferenceValue'
    * @return The current set of possible targets for the given wireSource
    */
   List getAllMatchingTargets(WireSource wireSource);

   /**
    * 
    * @param wireTarget
    *           a non-null WireTarget (generally one of 'ExternalService' or
    *           'Service')
    * @return The current set of possible sources for the given wireTarget
    */
   List getAllMatchingSources(WireTarget wireTarget);

   /**
    * Return a list of all WireSource elements within this Composite which are
    * wired to the passed wireTarget.
    * 
    * @param wireTarget
    * @return Collection
    * 
    * @see WireSource
    */
   Collection getAllWiredSources(WireTarget wireTarget);

   /**
    * Return an {@link ExternalService} with a matching name.
    * 
    * @param name
    * @return ExternalService
    */
   ExternalService getExternalService(String name);

   /**
    * Return an {@link EntryPoint} with a matching name.
    * 
    * @param name
    * @return EntryPoint
    */
   EntryPoint getEntryPoint(String name);

   /**
    * Use this API to resolve target URIs to a {@link WireTarget} within the
    * composite. The targetURI in the form "[Component name]/[opt service name]"
    * when pointing to a service on a Component. The service name is optional if
    * there is only one service on the Component. It is an error condition if
    * the service name is not provided and there is more than one service on the
    * component. In this situation the targetInterface is optional.
    * 
    * The targetURI for an ExternalService will be in the form "[ExternalService
    * name]". No service name is required for an ExternalService since it is by
    * definition a single service. In this situation the targetInterface is
    * optional.
    * 
    * @param targetURI
    * @return WireTarget
    */
   WireTarget resolveWireTarget(String targetURI);

   /**
    * Use this API to resolve soure URIs to a {@link WireSource} within the
    * composite. The sourceURI in the form "[Component name]/[reference name]"
    * when pointing to a reference on a Component.
    * 
    * The sourceURI for an {@link EntryPoint} will be in the form "[EntryPoint
    * name]".
    * 
    * @param sourceURI
    * @return WireSource
    */
   WireSource resolveWireSource(String sourceURI);

   /**
    * @param componentName
    *           The name of configurable to search for
    * @return The specific {@link Component} of the given name, if available or
    *         null otherwise.
    */
   Component getComponent(String componentName);

} // Composite
