/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.List;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stp.core.introspection.FeatureAdapter;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>External Service</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.ExternalService#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ExternalService#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ExternalService#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ExternalService#getOverridable <em>Overridable</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ExternalService#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getExternalService()
 * @model extendedMetaData="name='ExternalService' kind='elementOnly'"
 * @extends WireTarget
 * @extends AbstractService
 */
public interface ExternalService extends SCAObject, WireTarget, AbstractService {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getExternalService_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':4' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Name</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Name</em>' attribute.
    * @see #setName(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getExternalService_Name()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        required="true" extendedMetaData="kind='attribute' name='name'"
    * @generated
    */
   String getName();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ExternalService#getName <em>Name</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Name</em>' attribute.
    * @see #getName()
    * @generated
    */
   void setName(String value);

   /**
    * Returns the value of the '<em><b>Overridable</b></em>' attribute. The
    * default value is <code>"may"</code>. The literals are from the
    * enumeration {@link org.eclipse.stp.core.sca.OverrideOptions}. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Overridable</em>' attribute isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Overridable</em>' attribute.
    * @see org.eclipse.stp.core.sca.OverrideOptions
    * @see #isSetOverridable()
    * @see #unsetOverridable()
    * @see #setOverridable(OverrideOptions)
    * @see org.eclipse.stp.core.sca.SCAPackage#getExternalService_Overridable()
    * @model default="may" unique="false" unsettable="true"
    *        extendedMetaData="kind='attribute' name='overridable'"
    * @generated
    */
   OverrideOptions getOverridable();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ExternalService#getOverridable <em>Overridable</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Overridable</em>' attribute.
    * @see org.eclipse.stp.core.sca.OverrideOptions
    * @see #isSetOverridable()
    * @see #unsetOverridable()
    * @see #getOverridable()
    * @generated
    */
   void setOverridable(OverrideOptions value);

   /**
    * Unsets the value of the '{@link org.eclipse.stp.core.sca.ExternalService#getOverridable <em>Overridable</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isSetOverridable()
    * @see #getOverridable()
    * @see #setOverridable(OverrideOptions)
    * @generated
    */
   void unsetOverridable();

   /**
    * Returns whether the value of the '{@link org.eclipse.stp.core.sca.ExternalService#getOverridable <em>Overridable</em>}'
    * attribute is set. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return whether the value of the '<em>Overridable</em>' attribute is
    *         set.
    * @see #unsetOverridable()
    * @see #getOverridable()
    * @see #setOverridable(OverrideOptions)
    * @generated
    */
   boolean isSetOverridable();

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getExternalService_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':7' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

   /**
    * The interface used by this object is likely to be an
    * implementation-specific substitution group.
    * 
    * This means that it is sometimes necessary to know the corresponding
    * {@link org.eclipse.emf.ecore.EStructuralFeature} when using this
    * Interface, particularly when saving the underlying XML. Clients should use
    * {@link FeatureAdapter#setFeature(SCAObject, EStructuralFeature)} or
    * {@link FeatureAdapter#getFeature(SCAObject)}.
    * 
    * @return The Interface for this ExternalService.
    * 
    * @see FeatureAdapter
    * @see FeatureAdapter#getFeature(SCAObject)
    */
   public Interface getInterface();

   /**
    * The interface used by this object is likely to be an
    * implementation-specific substitution group.
    * 
    * This means that it is sometimes necessary to know the corresponding
    * {@link org.eclipse.emf.ecore.EStructuralFeature} when using this
    * Interface, particularly when saving the underlying XML. Clients should use
    * {@link FeatureAdapter#setFeature(SCAObject, EStructuralFeature)} or
    * {@link FeatureAdapter#getFeature(SCAObject)}.
    * 
    * @param newInterface
    *           The Interface for this ExternalService. Clients are required to
    *           set the correct feature before calling this method.
    * @see FeatureAdapter
    * @see FeatureAdapter#setFeature(SCAObject, EStructuralFeature)
    */
   public void setInterface(Interface newInterface);

   /**
    * Before adding entries to this list, be sure that the binding has the
    * correct feature set. Use
    * {@link FeatureAdapter#setFeature(SCAObject, EStructuralFeature)} to set
    * the features.
    * 
    * @return The list of bindings. Entries in this list should be of type
    *         {@link Binding}.
    */
   public List getBindings();

} // ExternalService
