/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>WSDL Port Type</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.WSDLPortType#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.WSDLPortType#getCallbackInterface <em>Callback Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.WSDLPortType#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.WSDLPortType#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getWSDLPortType()
 * @model extendedMetaData="name='WSDLPortType' kind='elementOnly'"
 * @generated
 */
public interface WSDLPortType extends Interface {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getWSDLPortType_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':0' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Callback Interface</b></em>'
    * attribute. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Callback Interface</em>' attribute isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Callback Interface</em>' attribute.
    * @see #setCallbackInterface(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getWSDLPortType_CallbackInterface()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        extendedMetaData="kind='attribute' name='callbackInterface'"
    * @generated
    */
   String getCallbackInterface();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.WSDLPortType#getCallbackInterface <em>Callback Interface</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Callback Interface</em>'
    *           attribute.
    * @see #getCallbackInterface()
    * @generated
    */
   void setCallbackInterface(String value);

   /**
    * Returns the value of the '<em><b>Interface</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Interface</em>' attribute isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Interface</em>' attribute.
    * @see #setInterface(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getWSDLPortType_Interface()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        required="true" extendedMetaData="kind='attribute'
    *        name='interface'"
    * @generated
    */
   String getInterface();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.WSDLPortType#getInterface <em>Interface</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Interface</em>' attribute.
    * @see #getInterface()
    * @generated
    */
   void setInterface(String value);

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getWSDLPortType_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':3' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

} // WSDLPortType
