/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.SCAObject;

public abstract class SCAObjectImpl extends EObjectImpl implements SCAObject {

   private MultiStatus status;

   public MultiStatus addStatus(IStatus aNewStatus) {
      if (status == null)
         status = new MultiStatus(STPCorePlugin.PLUGIN_ID, 0,
               Messages.Model_consistency_status_message, null);
      if (aNewStatus != null)
         status.add(aNewStatus);
      return status;
   }

   public void clearStatus() {
      status = new MultiStatus(STPCorePlugin.PLUGIN_ID, 0,
            Messages.Model_consistency_status_message, null);
      status.add(Status.OK_STATUS);
   }

   public MultiStatus getStatus() {
      return status;
   }
}
