/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import java.util.Collections;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

class UnresolvedWireHandle extends SCAObjectImpl implements WireTarget,
      WireSource {
   private String name;

   UnresolvedWireHandle(String name) {
      this.name = name == null ? "" : name; //$NON-NLS-1$
   }

   public Interface getInterface() {
      return null;
   }

   public boolean matches(WireSource wireSource) {
      Assert.isNotNull(wireSource);
      if (getInterface() != null)
         return getInterface().equals(wireSource.getInterface());
      return false;
   }

   public int getFlags() {
      return IConstants.F_DEFAULT;
   }

   public EObject getEObject() {
      return null;
   }

   public void setName(String name) {
      Assert.isNotSupported("UnresolvedWireHandle#setName(String)"); //$NON-NLS-1$
   }

   public String getName() {
      return name;
   }

   public boolean isResolved() {
      return false;
   }

   public boolean matches(WireTarget wireTarget) {
      Assert.isNotNull(wireTarget);
      if (getInterface() != null)
         return getInterface().equals(wireTarget.getInterface());
      return false;
   }

   public void createWireToTarget(WireTarget wireTarget) {
      Assert
            .isNotSupported("UnresolvedWireHandle#createWireToTarget(WireTarget)"); //$NON-NLS-1$

   }

   public List getWiredTargets() {
      return Collections.EMPTY_LIST;
   }

   public boolean deleteWireToTarget(WireTarget wireTarget) {
      return false;
   }

   public boolean isComponentOwned() {
      return false;
   }
}
