/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.ui.contribution;


/**
 * Describes an entry in the {@link SOAPropertiesRegistry}
 */
public interface ISOAPropertiesEntry {
	/**
	 * Gets a default contribution
	 * 
	 * @return a default contribution
	 */
	public ISOAPropertiesContribution getContributor();
	/**
	 * Creates a new contribution
	 * 
	 * @return the new contribution
	 */
	public ISOAPropertiesContribution newContributor();
	
	/**
	 * Identifies the ID
	 * @return the ID
	 */
	public String getId();
	
	/**
	 * Identifies the contributing plugin
	 * @return the bundle
	 */
	public String getContributorPluginID();
	
	/**
	 * Identifies the typeName
	 * @return the type name
	 */
	public String getTypeName();
	
	/**
	 * Identifies the className
	 * @return the class name
	 */
	public String getClassName();

	/**
	 * Identifies the namespaceURI of the type
	 * @return the namespaceURI of the type
	 */
	public String getNamespaceURI();
}
