/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.AssertionFailedException;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/**
 * 
 *
 */
public class ComponentTypingOperation extends AbstractDataModelOperation {
	
	private Component component;
	private Implementation oldImplementation;
	private boolean setType = false;
	private String type = null;
	private String oldType = null;
	
	/**
	 * @param operationDataModel
	 */
	public ComponentTypingOperation(IDataModel operationDataModel) {
		super(operationDataModel);
	}
	
	public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		component = (Component)model.getProperty(IComponentTypingDataModelProperties.COMPONENT);
		setType = model.getBooleanProperty(IComponentTypingDataModelProperties.SET_TYPE);
		type = model.getStringProperty(IComponentTypingDataModelProperties.TYPE);
		
		oldImplementation = component.getImplementation();

		if (setType) {
			if(oldImplementation == null){
				component.setAbstractImplementation(SCAFactory.eINSTANCE.createComponentType());
				AbstractImplementation impl = (AbstractImplementation) component.getImplementation();
				impl.setType(type);
			}else{
				if(oldImplementation instanceof AbstractImplementation){
					oldType = ((AbstractImplementation)oldImplementation).getType();
					((AbstractImplementation)oldImplementation).setType(type);
				}else{
					String message = NLS.bind(Messages.stp_core_saf_unableToSetKindForTypedComponent, type);
					throw new ExecutionException(message, new SAFException()); 
				}
			}
			
		}else{
			if(oldImplementation instanceof AbstractImplementation){
				oldType = ((AbstractImplementation)oldImplementation).getType();
				((AbstractImplementation)oldImplementation).setType(null);
			}else{
				if(oldImplementation == null){
					component.setAbstractImplementation(SCAFactory.eINSTANCE.createComponentType());
				}else{
					ComponentType compType = null;
					try{
						compType = component.resolveComponentType();
					}catch (AssertionFailedException e){
						compType = SCAFactory.eINSTANCE.createComponentType();
					}
					component.setAbstractImplementation(compType);
				}
			}
		}
     
        return Status.OK_STATUS;
	}

	public boolean canRedo() {
		return false;
	}
	
	public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		//Nothing to redo
		return OK_STATUS;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.operations.IUndoableOperation#undo(org.eclipse.core.runtime.IProgressMonitor, org.eclipse.core.runtime.IAdaptable)
	 */
	public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		
		if (setType) {
			if(oldImplementation == null){
				component.setAbstractImplementation(null);
			}else if(oldImplementation instanceof AbstractImplementation){
				((AbstractImplementation)oldImplementation).setType(oldType);
			}
		}else{
			if(oldImplementation instanceof AbstractImplementation){
				((AbstractImplementation)oldImplementation).setType(oldType);
			}else{
				if(oldImplementation == null){
					component.setAbstractImplementation(null);
				}else{
					component.setSpecializedImplementation(oldImplementation);
				}
			}
		}
     
        return Status.OK_STATUS;
        
	}
	
	
}
