/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.deploy.wtp;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.CeltixKitUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.deploy.IDeployDelegate;
import org.eclipse.stp.sc.jaxws.deploy.wtp.RuntimeSelectionDialog;
import org.eclipse.stp.sc.jaxws.deploy.wtp.WtpUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WTPDeployer
implements IDeployDelegate {
    public static final String FACET_JST_WEB = "jst.web";
    public static final String FACET_JST_WEB_VERSION = "2.3";
    public static final String FACET_JST_JAVA = "jst.java";
    public static final String FACET_JST_JAVA_VERSION = "5.0";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPDeployer.class);
    private static final String FACET_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String WTP_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    IFacetedProject facetedProject;

    @Override
    public void deployWebService(IProject project, IFile wsdlFile, IProgressMonitor monitor) throws Exception {
        monitor.subTask(ScJaxWsResources.getString("wtpdeploy.monitor.createproject"));
        this.setupWTPProject(project);
        monitor.worked(10);
        monitor.subTask(ScJaxWsResources.getString("wtpdeploy.monitor.assemble"));
        SubProgressMonitor assembleMonitor = new SubProgressMonitor(monitor, 60);
        this.assembleWebContent(project, wsdlFile, (IProgressMonitor)assembleMonitor);
        monitor.worked(60);
        monitor.subTask(ScJaxWsResources.getString("wtpdeploy.monitor.setupruntime"));
        this.setupProjectFacets(project, monitor);
        monitor.worked(30);
        String url = WtpUtils.getServerUrl(wsdlFile);
        LOG.info((Object)("wsdl url on server:" + url));
    }

    private void addfacets(IFacetedProject facetProj, Set<IProjectFacetVersion> facets) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        for (IProjectFacetVersion facetVersion : facets) {
            IDataModel dm;
            if (facetProj.hasProjectFacet(facetVersion.getProjectFacet())) continue;
            if (facetVersion.getProjectFacet().getId().equals(FACET_JST_JAVA)) {
                dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetInstallDataModelProvider());
                dm.setProperty("IFacetDataModelProperties.FACET_ID", (Object)facetVersion.getProjectFacet().getId());
                dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)facetProj.getProject().getName());
                dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)facetVersion.getVersionString());
            } else {
                dm = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
                dm.setProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", (Object)facetProj.getProject().getName());
                dm.setProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", (Object)facetProj.getProject().getName());
            }
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, (Object)dm));
        }
        try {
            if (!actions.isEmpty()) {
                facetProj.modify(actions, null);
            }
        }
        catch (CoreException e) {
            LOG.error((Object)"error during add project facets", (Throwable)e);
        }
    }

    protected void setupProjectFacets(IProject project, IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)"add jst.web and jst.java facet to project");
        this.facetedProject = ProjectFacetsManager.create((IProject)project);
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)FACET_JST_WEB);
        IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)FACET_JST_JAVA);
        IProjectFacetVersion webFacetVersion = webFacet.getVersion(FACET_JST_WEB_VERSION);
        IProjectFacetVersion javaFacetVersion = javaFacet.getVersion(FACET_JST_JAVA_VERSION);
        HashSet<IProjectFacetVersion> defaultFacets = new HashSet<IProjectFacetVersion>();
        if (!this.facetedProject.hasProjectFacet(javaFacet)) {
            defaultFacets.add(javaFacetVersion);
        }
        if (!this.facetedProject.hasProjectFacet(webFacet)) {
            defaultFacets.add(webFacetVersion);
        }
        this.addfacets(this.facetedProject, defaultFacets);
        Set runtimes = RuntimeManager.getRuntimes();
        HashSet<IRuntime> webRuntimes = new HashSet<IRuntime>();
        for (IRuntime runtime : runtimes) {
            if (!runtime.supports(webFacet) || !runtime.supports(webFacetVersion) || !runtime.supports(javaFacet) || !runtime.supports(javaFacetVersion)) continue;
            webRuntimes.add(runtime);
        }
        if (webRuntimes.size() == 0) {
            LOG.info((Object)"did not set target runtime since no runtime has been installed");
            return;
        }
        project.refreshLocal(2, null);
        try {
            this.facetedProject.setTargetedRuntimes(webRuntimes, monitor);
        }
        catch (Exception ee) {
            LOG.debug((Object)ee.toString());
        }
        this.facetedProject.setTargetedRuntimes(webRuntimes, monitor);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    Shell shell = new Shell(Display.getDefault());
                    RuntimeSelectionDialog dialog = new RuntimeSelectionDialog(shell);
                    if (dialog.open() == 0) {
                        IRuntime runtime = dialog.getSelectedRuntime();
                        WTPDeployer.this.facetedProject.setPrimaryRuntime(runtime, null);
                        this.setupServer(runtime.getName(), WTPDeployer.this.facetedProject.getProject());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }

            private void setupServer(String runtimeName, IProject project) throws CoreException {
                IServer[] servers;
                IModule module = ServerUtil.getModule((IProject)project);
                IServer[] iServerArray = servers = ServerCore.getServers();
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    IServer server = iServerArray[n2];
                    if (server.getRuntime().getName().equals(runtimeName)) {
                        if (ServerUtil.containsModule((IServer)server, (IModule)module, null)) {
                            LOG.info((Object)("project already deployed on server" + server));
                            return;
                        }
                        IModule[] add = new IModule[]{module};
                        LOG.info((Object)("deploy project:" + project.getName() + " to server:" + server.getName()));
                        IServerWorkingCopy workingCopy = server.createWorkingCopy();
                        ServerUtil.modifyModules((IServerWorkingCopy)workingCopy, (IModule[])add, null, null);
                        workingCopy.save(true, null);
                        ServerCore.setDefaultServer((IModule)module, (IServer)server, null);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    protected void setupWTPProject(IProject project) {
        try {
            JaxWsWorkspaceManager.addProjectNature((IProject)project, (String)FACET_NATURE);
            JaxWsWorkspaceManager.addProjectNature((IProject)project, (String)WTP_NATURE);
        }
        catch (Exception e) {
            LOG.error((Object)"error during add wtp nature", (Throwable)e);
        }
    }

    protected void assembleWebContent(IProject project, IFile wsdlFile, IProgressMonitor monitor) {
        try {
            monitor.beginTask(ScJaxWsResources.getString("wtpdeploy.monitor.copywebxml"), 5);
            IFile webXmlFile = JaxWsWorkspaceManager.getWebXmlFile(project);
            if (!webXmlFile.exists()) {
                String webXmlFilePath = CeltixKitUtils.getWebXmlPath();
                JaxWsWorkspaceManager.copyFile((String)webXmlFilePath, (IFile)webXmlFile, (boolean)false, (IProgressMonitor)monitor);
            }
            monitor.worked(5);
            monitor.beginTask(ScJaxWsResources.getString("wtpdeploy.monitor.copyservletxml"), 5);
            IFolder webInfFolder = JaxWsWorkspaceManager.getWebInfFolder(project);
            IFile configFile = JaxWsWorkspaceManager.getServletConfigFile(project);
            JaxWsWorkspaceManager.copyFile((IFile)configFile, (IFolder)webInfFolder, (IProgressMonitor)monitor);
            monitor.worked(5);
            monitor.beginTask(ScJaxWsResources.getString("wtpdeploy.monitor.copywsdl"), 10);
            IContainer wsdlFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
            HashSet<String> extensions = new HashSet<String>();
            extensions.add("wsdl");
            JaxWsWorkspaceManager.copyFilesInFolder((IContainer)wsdlFolder, (IFolder)JaxWsWorkspaceManager.getWebWSDLFolder(project), extensions, (IProgressMonitor)monitor);
            monitor.worked(10);
            monitor.beginTask(ScJaxWsResources.getString("wtpdeploy.monitor.copyjars"), 80);
            String libPath = CeltixKitUtils.getLibPath();
            JaxWsWorkspaceManager.copyFilesInFolder((String)libPath, (IFolder)JaxWsWorkspaceManager.getWebLibFolder(project), (String)".jar", (boolean)false, (IProgressMonitor)monitor);
            monitor.worked(80);
        }
        catch (Exception e) {
            LOG.error((Object)"error during assemble web content", (Throwable)e);
        }
    }
}

