/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.internal.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.viewers.StpRuntimeComposite;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlGenPage;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSettingPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeSelectionPage
extends WizardPage {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeSelectionPage.class);
    public StpRuntimeComposite runtimeComp;
    IRuntime selectedRuntime = null;

    public RuntimeSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)1808);
        composite.setLayout((Layout)new GridLayout());
        String[] moduleTypes = new String[]{"stp.jaxws.component"};
        this.runtimeComp = new StpRuntimeComposite(composite, 0, new StpRuntimeComposite.SelectionListener(){

            public void runtimeSelected(IRuntime runtime) {
                LOG.debug((Object)("runtime selected:" + runtime.getId()));
                RuntimeSelectionPage.this.selectedRuntime = runtime;
                RuntimeSelectionPage.this.setPageComplete(RuntimeSelectionPage.this.validatePage());
                RuntimeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        }, moduleTypes);
        this.runtimeComp.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() instanceof WsdlFirstProjectWizard) {
            WsdlGenPage genPage = (WsdlGenPage)this.getWizard().getPage("genPage");
            genPage.updateControl(this.selectedRuntime.getRuntimeType().getId());
            WsdlSettingPage wsdlPage = (WsdlSettingPage)this.getWizard().getPage("wsdlPage");
            return wsdlPage;
        }
        return super.getNextPage();
    }

    public boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.selectedRuntime == null) {
            this.setErrorMessage(ScJaxWsResources.getString("runtimepage.error.noruntime"));
            return false;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        if (this.selectedRuntime == null) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public String getRuntimeType() {
        return this.selectedRuntime.getRuntimeType().getId();
    }

    public String getRuntimeID() {
        return this.selectedRuntime.getId();
    }

    public void selectRuntimeByIndex(int index) {
        LOG.debug((Object)("set select runtime by index:" + index));
        this.selectedRuntime = this.runtimeComp.selectRuntimeByIndex(index);
        LOG.debug((Object)("result runtime:" + this.selectedRuntime));
    }
}

