/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxwsri.preferences;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SCJAXWSRIPreferencePage extends FieldEditorPreferencePage implements
		IWorkbenchPreferencePage {
	
	public static final String KEY_SOAP_OPTION = "KEY_SOAP_OPTION_FOR_JAXWSRI";

	IPreferenceStore mStore = null;
	
	public SCJAXWSRIPreferencePage() {
		super(GRID);
		mStore = ScJaxWsPlugin.getDefault().getPreferenceStore();
        setPreferenceStore(mStore);
	}
	
	@Override
	protected void createFieldEditors() {
		createJavaToWsdlGroup();
	}

	public void init(IWorkbench workbench) {
		// TODO Auto-generated method stub

	}

    private void createJavaToWsdlGroup() {
        Group grpWsdlGen = new Group(getFieldEditorParent(), SWT.NONE);
        grpWsdlGen.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
        grpWsdlGen.setLayout(new FillLayout());
        grpWsdlGen.setText(ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.grp"));

        String soap11 = ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.soap11.label");
        String soap12 = ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.soap12.label");
        
        String[][] lnv = new String[][] {{soap11, SCPreferenceConstants.KEY_SOAP11}, {soap12, SCPreferenceConstants.KEY_SOAP12}};
        RadioGroupFieldEditor soapOption = new RadioGroupFieldEditor(KEY_SOAP_OPTION, "", 2,
                lnv, grpWsdlGen, false);

        addField(soapOption);
    }

}
