/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.actions.CreateActionBase;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;


public class CreateWebMethodAction extends CreateActionBase {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CreateWebMethodAction.class);
    
    public CreateWebMethodAction() {
        super();

        // TODO Auto-generated constructor stub
    }

    public void dispose() {
        // TODO Auto-generated method stub
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (selection != null && !selection.isEmpty()) {
            try {

                if (!(selection.getFirstElement() instanceof IMember)) {
                    return;
                }
                IMember selMember = (IMember)selection.getFirstElement();
                IResource javaFileResource = selMember.getResource();

                if (javaFileResource != null && !isJavaEditorOpen(javaFileResource)) {
                    openJavaEditor(javaFileResource);
                }

                CreateWebMethodWizard wizard = new CreateWebMethodWizard(selMember);
                
                if (PreferencesAccessor.areAnnWizardsDisplaied() || selMember instanceof IType) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new ScWizardDialog(shell, wizard).open();
                } else {
                    wizard.performFinish();
                }

            } catch (Exception e) {
                LOG.debug("exception on wizard run", e);
            }
        }
    }
    
    public void selectionChanged(IAction action, ISelection sel) {
    	super.selectionChanged(action, sel);
    	if(sel != null && sel instanceof IStructuredSelection){
    		Object selectedObject = ((IStructuredSelection)sel).getFirstElement();
    		if(selectedObject instanceof IMethod){
    	         try{
    	        	 action.setEnabled(false);
    	        	 IJavaElement parent = ((IMethod)selectedObject).getParent();
    	        	 if(parent instanceof IType && ((IType)parent).isInterface()){
    	        		 action.setEnabled(true);
    	        	 } else{
    	        		 int flags = ((IMethod)selectedObject).getFlags();
        	        	 if(Flags.isPublic(flags)){
        	        		 action.setEnabled(true);
        	        	 }
    	        	 }
    	         } catch(JavaModelException e){
    	        	 LOG.error("error during checking method flags", e);
    	         }
    		}
    	}
    }
}
