/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.annotations;

import java.util.Iterator;
import java.util.List;
import javax.jws.WebParam;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;


public class WebParamAnnInfo extends WebAnnInfo {
    public static final String ATTR_MODE = "mode";
    WebParam.Mode mode = WebParam.Mode.IN; //in is the default mode

    public WebParamAnnInfo() {
        super();
    }
    
    public WebParamAnnInfo(Annotation ann) {
        super(ann);

        NormalAnnotation normalAnn = (NormalAnnotation)ann;
        List list = normalAnn.values();
        Iterator itor = list.iterator();

        while (itor.hasNext()) {
            MemberValuePair valuePair = (MemberValuePair)itor.next();
            String attrKey = valuePair.getName().getFullyQualifiedName();
            if (attrKey.equals(ATTR_MODE)) {
                Expression value = valuePair.getValue();
                if (value instanceof QualifiedName) {
                    mode = WebParam.Mode.valueOf(((QualifiedName)value).getName().getIdentifier());
                }
            }
        }
    }

    public WebParam.Mode getMode() {
        return mode;
    }

    public void setMode(WebParam.Mode value) {
        this.mode = value;
    }
}
