/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.workspace;

import org.eclipse.stp.sc.common.views.AnnotationView;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class ScPerspective implements IPerspectiveFactory {

    public static final String CELTIX_PERSPECTIVE_ID = "org.eclipse.stp.sc.jaxws.perspective";
    
    private static final String JDT_PACKAGE_NAV_ID = "org.eclipse.jdt.ui.PackageExplorer";
    private static final String ANNOTATION_VIEW_ID = AnnotationView.ANNOTATION_VIEW_ID;
    private static final String CELTIX_ID = "org.eclipse.stp.sc.jaxws.actionSet.id";
    
    
    
    public void createInitialLayout(IPageLayout layout) {
        defineLayout(layout);
        defineActions(layout);
        defineShortcuts(layout);
    }
    
    private void defineShortcuts(IPageLayout layout) {
        
    }
    
    public void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        // Get editor area
        IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, (float)0.25, editorArea);
        // Navigator and Outline views
        topLeft.addView(IPageLayout.ID_RES_NAV);
        topLeft.addView(JDT_PACKAGE_NAV_ID);
        
        // Bottom left: Outline View
        IFolderLayout bottomLeft = layout.createFolder("bottomLeft", IPageLayout.BOTTOM, 0.50f, "topLeft");
        bottomLeft.addView(IPageLayout.ID_OUTLINE);
        // Bottom-Right
        IFolderLayout bottom = layout.createFolder("bottom", IPageLayout.BOTTOM, 0.66f, editorArea);
        bottom.addView(ANNOTATION_VIEW_ID);
        bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
    }
    
    public void defineActions(IPageLayout layout) {
        layout.addActionSet(CELTIX_ID);
    }
    
    

}
