/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.runtimeprovider;


import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

/**
 * not intended to be implemented by users
 */
public interface IRuntimeKitProcessor {

    /**
     * adds the complete list of default libraries to the build path of the given java project (except for
     *  duplicates)
     * @throws CoreException 
     */
    public void completeJavaProjectBuildPath(IJavaProject project) throws JavaModelException, CoreException;

    /**
     * removes all the libraries previously added by the kit processor to given java project
     */
    public void clearJavaProjectBuildPath(IJavaProject project) throws JavaModelException, CoreException;

}