/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.annotations;

import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;


public class AttributeControlProxy {

    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_ENUM = 2;
    
    static final String STR_FALSE = "false";
    static final String STR_TRUE = "true";
    static final String STR_EMPTY = "";
    static final String[] COMBO_VAL_BOOLEAN = {STR_EMPTY, STR_TRUE, STR_FALSE};

    private int type;
    private String name;
    private Control control;

    private AttributeControlProxy(int aType, String aName, Control aValue) {
        type = aType;
        name = aName;
        control = aValue;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Control getControl() {
        return control;
    }

    public static AttributeControlProxy createInstance(Group parentContainer,
                                                       String attributeName,
                                                       Class attributeTypeClass,
                                                       ModifyListener listener) {
        int attributeType;
        Control attributeWidget;
       // support booleans
        if (attributeTypeClass.equals(Boolean.TYPE)) {
            attributeType = AttributeControlProxy.TYPE_BOOLEAN;
            attributeWidget = createControlForBooleanAttribute(parentContainer, listener);
           
        // support enums
        } else if (attributeTypeClass.isEnum()) {
            attributeType = AttributeControlProxy.TYPE_ENUM;
            attributeWidget = createControlForEnumAttribute(parentContainer, attributeTypeClass, listener);
    
        // support everything else as string literals (strings, numerics, dates, ...)
        } else /*if (returnTypeClass.equals(String.class)
                    || returnTypeClass.equals(Integer.TYPE) || returnTypeClass.equals(Integer.class)
                    || returnTypeClass.equals(Long.TYPE) || returnTypeClass.equals(Long.class)
                    || returnTypeClass.equals(Float.TYPE) || returnTypeClass.equals(Float.class)
                    || returnTypeClass.equals(Double.TYPE) || returnTypeClass.equals(Double.class))*/ {
                attributeType = AttributeControlProxy.TYPE_STRING;
                attributeWidget = createControlForTextAttribute(parentContainer, listener);
        } 
        AttributeControlProxy attrib = new AttributeControlProxy(attributeType, attributeName, attributeWidget);
        return attrib;
    }

    public void setControlValue(MemberValuePair newValue) {

        String strValue = newValue == null ? null : newValue.getValue().toString();
        
         if ((strValue != null) && (strValue.length() != 0)) {
             if (strValue.indexOf('"') == 0) {
                 strValue = strValue.substring(1, strValue.length() - 1);
             }
    
             if (type == AttributeControlProxy.TYPE_STRING) {
                 ((Text)getControl()).setText(strValue);
              
             } else if(type == AttributeControlProxy.TYPE_BOOLEAN
                       || type == AttributeControlProxy.TYPE_ENUM) {
                
                 String[] items = ((Combo)getControl()).getItems();
                 for (int comboIndex = 0; comboIndex < items.length; comboIndex++) {
                     if (items[comboIndex].equals(strValue)) {
                          ((Combo)getControl()).select(comboIndex);
                          break;
                     }
                 }
             }
         }
    }
   
    public void clearControlValue() {
         if (type == AttributeControlProxy.TYPE_STRING) {
             ((Text)getControl()).setText("");
          
         } else if(type == AttributeControlProxy.TYPE_BOOLEAN
                   || type == AttributeControlProxy.TYPE_ENUM) {
              ((Combo)getControl()).clearSelection();
         }
    }

    public Object getControlValue() {
        Object controlValue = null;
    
        if (type == AttributeControlProxy.TYPE_STRING) {
            String strValue = ((Text)getControl()).getText();
            if ((strValue != null) && (strValue.length() != 0)) {
                controlValue = strValue;
            }
         
        } else if(type == AttributeControlProxy.TYPE_BOOLEAN) {
            String strValue = ((Combo)getControl()).getText();
            controlValue = AttributeControlProxy.STR_TRUE.equals(strValue);
        
        } else if(type == AttributeControlProxy.TYPE_ENUM) {
            String strValue = ((Combo)getControl()).getText();
            controlValue = strValue;
        }
        
        return controlValue;
    }

    private static Control createControlForEnumAttribute(Group grpAttrib,
                                                         Class returnTypeClass,
                                                         ModifyListener listener) {
       Combo comboEnums = new Combo(grpAttrib, SWT.READ_ONLY | SWT.DROP_DOWN);
      
       final Object[] enumsConstants = returnTypeClass.getEnumConstants();
       String[] comboValues = new String[enumsConstants.length];
       for (int i = 0; i < enumsConstants.length; i++) {
           comboValues[i] = enumsConstants[i].toString();
       }
       comboEnums.setItems(comboValues);
       comboEnums.addModifyListener(listener);

       return comboEnums;
    }

    private static Control createControlForBooleanAttribute(Group grpAttrib,
                                                            ModifyListener listener) {
        Combo comboBoolean = new Combo(grpAttrib, SWT.READ_ONLY | SWT.DROP_DOWN);
        comboBoolean.setItems(AttributeControlProxy.COMBO_VAL_BOOLEAN);
        comboBoolean.addModifyListener(listener);
        return comboBoolean;
    }

    private static Control createControlForTextAttribute(Group grpAttrib,
                                                         ModifyListener listener) {
        Text txtCtrl;
        txtCtrl = new Text(grpAttrib, SWT.SINGLE | SWT.BORDER);
        txtCtrl.addModifyListener(listener);
        return txtCtrl;
    }
}
