/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxwsri.generators;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.LaunchUtil;
import org.eclipse.stp.sc.jaxwsri.JAXWSRIPlugin;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class JAXWSRIWsdlToJavaGenerator implements IWsdlToJavaGenerator{
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JAXWSRIWsdlToJavaGenerator.class);
    
    private Hashtable toolParams = new Hashtable();
    
    public void setInitializationData(IConfigurationElement config,
                                      String propertyName,
                                      Object data) throws CoreException {
        if (data instanceof Hashtable) {
        	toolParams = (Hashtable)data;
        }
    }
    
    public void run(IPath path, IProject project) throws CoreException {
        String url;
        try {
            url = path.toFile().toURL().toExternalForm();
            run(url, project);
        } catch (MalformedURLException e) {
        	LOG.error(e);
        }
        
    }

    
      public void run(String url, IProject project) throws CoreException {
        try {
        	
        	if(project == null || url == null){
        		LOG.error("wsdl to java generation error: the wsdl url or project is null");
        		return;
        	}

        	IJavaProject javaProject = JDTUtils.findJavaProject(project.getName());
        	if(javaProject == null || !javaProject.exists()){
        		LOG.error("wsdl to java generation error: the project cannot be found");
        		return;
        	}
        	
        	ArrayList<String> args = new ArrayList<String>();
            
            //source code output dir
            String outDir = (String)toolParams.get(IWsdlToJavaGenerator.GEN_OUTPUTDIR);
            LOG.debug("Wsdl to Java output dir: " + outDir);
            File file = new File(outDir);
            if (!file.exists()) {
            	file.mkdirs();
            }
            args.add(ToolConstants.WSDL2JAVA_PARA_SOURCE_OUTPUT_DIR);
            args.add(outDir);
            
            Map specificParams = (Map)toolParams.get(IWsdlToJavaGenerator.TOOL_SPECIFIC_OPS);
            
            //verbose
            String miscOps = (String)specificParams.get(ToolConstants.WSDL2JAVA_PARA_VERBOSE);
            if (miscOps != null) {
                LOG.debug("The verbose option has been set");
                args.add(ToolConstants.WSDL2JAVA_PARA_VERBOSE);
            }
            
            //wsdl
            args.add(url);
            
            //add tools.jar located in JDK_HOME to class path
            IVMInstall vmIns = JavaRuntime.getVMInstall(javaProject);
            File insLocation = vmIns.getInstallLocation();
            File libFile = new File(insLocation.getAbsolutePath() + File.separator + "lib" + File.separator + "tools.jar");
            if(!libFile.exists()){
            	final Display display = PlatformUI.getWorkbench().getDisplay();
            	display.syncExec(new Runnable() {
            	      public void run() {
            	    	  try{
            	    		  MessageDialog.openError(
                            			JAXWSRIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
                            			"Missing library",
                            			"Cannot find tools.jar in current JRE used by this project. Please use annother JRE that contains tools.jar for this project."
                            			);  
            	    	  }catch (Throwable e){
            	    		  e.printStackTrace();
            	    	  }
            	      }
            	     });
            	return;
            }

            LaunchUtil.launchJavaProgram(javaProject, ToolConstants.WSDL2JAVA_GENERATOR_CLASS, null, args.toArray(new String[0]), new String[]{libFile.getAbsolutePath()});
            project.refreshLocal(IProject.DEPTH_INFINITE, null);
            
        } catch (Exception e) {
            LOG.error("wsdl to java generation error", e);
        }
    }
   
}
