/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.generators;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.common.utils.LaunchUtil;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;


/*
 * TODO: remove IJavaToWsdlGenerator later once the refactor has finished.
 */
public class CeltixJavaToWsdlGenerator implements IJavaToWsdlGenerator {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixJavaToWsdlGenerator.class);
    
    public void setInitializationData(IConfigurationElement config,
        String propertyName, Object data) throws CoreException {
    }

    public void run(IPath path, IProject project) throws CoreException {
        LOG.info("generate WSDL for " + path.toString());

        try {

        	IContainer wsdlLocation = JaxWsWorkspaceManager.getWSDLGenFolder(path, project);
            
            LOG.info("WSDL location is: " + wsdlLocation);
            
            IJavaProject javaProject = JDTUtils.findJavaProject(project.getName());
            //program arguments
            ArrayList<String> args = new ArrayList<String>();
            
            String javaName = ResourceUtils.getFileNameWithoutExt(path);
            String wsdlUrl = wsdlLocation.getLocation().toOSString()
                                + File.separator 
                                + javaName
                                + ".wsdl";
            
            //OUTPUTFILE
            args.add(ToolConstants.JAVA2WSDL_PARA_OUTPUT_FILE);
            args.add(wsdlUrl);
            
            //SOURCEDIR, 
            args.add(ToolConstants.JAVA2WSDL_PARA_SOURCE_DIR);
            args.add(JaxWsWorkspaceManager.getSrcFolder(project).getLocation().toOSString());
            
            //CLASSDIR, 
            args.add(ToolConstants.JAVA2WSDL_PARA_CLASS_DIR);
            args.add(JaxWsWorkspaceManager.getClassesFolder(project).getLocation().toOSString());
            
            //classpath 
            String classPath = JDTUtils.getProjectClasspathAsString(project);
            LOG.debug("classpaths passed to j2w:" + classPath);
            args.add(ToolConstants.JAVA2WSDL_PARA_CLASS_PATH);
            args.add(classPath);

            //soap1.2 flag
            String soap12 = project.getPersistentProperty(
            		ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION);
            LOG.debug("soap12 from project: " + soap12);
            if (soap12 == null) {
            	if (PreferencesAccessor.getSoap12Option()) {
            		soap12 = "anyValue";
            		LOG.debug("soap12 is needed.");
            		args.add(ToolConstants.JAVA2WSDL_PARA_SOAP12);
            	}
            } else if (soap12.equals(SCPreferenceConstants.KEY_SOAP12)) {
                LOG.debug("soap12 is needed by project");
                args.add(ToolConstants.JAVA2WSDL_PARA_SOAP12);
            } 

            //target class
            IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String clsName = JDTUtils.getJavaClassNameFromFile(javaFile);
            LOG.debug("target cls name:" + clsName);
            if (clsName == null) {
                throw new Exception("failed to get java class name");
            }
            args.add(clsName);
            
            LaunchUtil.launchJavaProgram(javaProject, ToolConstants.JAVA2WSDL_GENERATOR_CLASS, null, args.toArray(new String[0]), null);
            LOG.debug("merge the geneared wsdl and schema file");
            
            project.refreshLocal(IProject.DEPTH_INFINITE, null);
        } catch (Throwable e) {
            LOG.error("Celtix Java To Wsdl Generation failure", e);
        }
    }
}
