/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.internal.viewers;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;

public class FilterRuntimeContentProvider
implements IStructuredContentProvider {
    protected String[] moduleTypes = null;
    protected String[] runtimeTypes = null;

    public void setModuleTypes(String[] types) {
        this.moduleTypes = types;
    }

    public void setRuntimeTypes(String[] types) {
        this.runtimeTypes = types;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (!this.filterRuntime(runtimes[i]) && !((Runtime)runtimes[i]).isPrivate()) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    private boolean filterRuntime(IRuntime runtime) {
        int n;
        if (this.moduleTypes == null && this.runtimeTypes == null) {
            return false;
        }
        if (this.runtimeTypes != null) {
            String[] stringArray = this.runtimeTypes;
            n = this.runtimeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String runtimeID = stringArray[n2];
                if (runtimeID.equals(runtime.getId())) {
                    return false;
                }
                ++n2;
            }
        }
        IModuleType[] types = runtime.getRuntimeType().getModuleTypes();
        if (this.moduleTypes != null) {
            String[] stringArray = this.moduleTypes;
            int n3 = this.moduleTypes.length;
            n = 0;
            while (n < n3) {
                String moduleType = stringArray[n];
                IModuleType[] iModuleTypeArray = types;
                int n4 = types.length;
                int n5 = 0;
                while (n5 < n4) {
                    IModuleType type = iModuleTypeArray[n5];
                    if (type.getId().equals(moduleType)) {
                        return false;
                    }
                    ++n5;
                }
                ++n;
            }
        }
        return true;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

