/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.common.logging.LoggingProxy;

public class FileUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(FileUtils.class);

    public static void createFromURL(IFile file, String urlStr) {
        try {
            LOG.debug((Object)("try to create wsdl file from url " + urlStr));
            URL url = new URL(urlStr);
            InputStream inputStream = url.openStream();
            file.create(inputStream, true, null);
        }
        catch (Exception e) {
            LOG.error((Object)"error during create wsdlfile from url", (Throwable)e);
        }
    }

    public static String getFileNameFromURL(String urlStr, String extension) {
        if (urlStr.lastIndexOf("/") > 0) {
            urlStr = urlStr.substring(urlStr.lastIndexOf("/") + 1);
        }
        if (urlStr.lastIndexOf("\\") > 0) {
            urlStr = urlStr.substring(urlStr.lastIndexOf("\\") + 1);
        }
        if (urlStr.lastIndexOf("?") > 0) {
            urlStr = urlStr.substring(urlStr.lastIndexOf("?") + 1);
        }
        if (extension != null) {
            if (urlStr.endsWith(extension)) {
                return urlStr;
            }
            return String.valueOf(urlStr) + extension;
        }
        return urlStr;
    }

    public static String getFileContent(String filePath) {
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            reader.close();
        }
        catch (Exception e) {
            LOG.error((Object)"error read from file", (Throwable)e);
        }
        return sb.toString();
    }

    public static String getURLContent(String urlStr) {
        StringBuffer sb = new StringBuffer();
        try {
            String inputLine;
            URL url = new URL(urlStr);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
                sb.append("\n");
            }
            in.close();
        }
        catch (Exception e) {
            LOG.error((Object)"error read from url", (Throwable)e);
        }
        return sb.toString();
    }

    public static String getFileName(String path) {
        if (path.lastIndexOf("/") >= 0) {
            return path.substring(path.lastIndexOf("/") + 1, path.length());
        }
        if (path.lastIndexOf("\\") >= 0) {
            return path.substring(path.lastIndexOf("\\") + 1, path.length());
        }
        return path;
    }

    /*
     * Loose catch block
     */
    public static boolean copyFile(InputStream is, String targetFileName) {
        FileOutputStream fos;
        block18: {
            fos = null;
            File targetFile = new File(targetFileName);
            targetFile.createNewFile();
            fos = new FileOutputStream(targetFile);
            int len = 1024;
            byte[] bytes = new byte[len];
            int count = 0;
            while ((count = is.read(bytes)) > 0) {
                fos.write(bytes, 0, count);
            }
            bytes = null;
            if (fos == null) break block18;
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return true;
        catch (Exception e) {
            block19: {
                try {
                    LOG.error((Object)("error during copy file to:" + targetFileName), (Throwable)e);
                    if (fos == null) break block19;
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            try {
                is.close();
            }
            catch (Exception exception) {}
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static String copyFile(String originalFile, String path) {
        String string;
        AbstractInterruptibleChannel wbc;
        AbstractInterruptibleChannel rbc;
        block21: {
            rbc = null;
            wbc = null;
            File oriFile = new File(originalFile);
            File targetFile = new File(path, oriFile.getName());
            targetFile.createNewFile();
            ByteBuffer bb = ByteBuffer.allocate(8192);
            rbc = new FileInputStream(oriFile).getChannel();
            wbc = new FileOutputStream(targetFile).getChannel();
            while (((FileChannel)rbc).read(bb) > 0) {
                bb.flip();
                ((FileChannel)wbc).write(bb);
                bb.clear();
            }
            string = String.valueOf(path) + File.separator + oriFile.getName();
            if (rbc == null) break block21;
            try {
                rbc.close();
            }
            catch (IOException iOException) {}
        }
        if (wbc != null) {
            try {
                wbc.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (Exception e) {
            block22: {
                try {
                    e.printStackTrace();
                    if (rbc == null) break block22;
                }
                catch (Throwable throwable) {
                    if (rbc != null) {
                        try {
                            rbc.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (wbc != null) {
                        try {
                            wbc.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    rbc.close();
                }
                catch (IOException iOException) {}
            }
            if (wbc != null) {
                try {
                    wbc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static boolean deleteFile(File f) {
        if (f.isDirectory()) {
            File[] files;
            File[] fileArray = files = f.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                boolean deleted = FileUtils.deleteFile(file);
                if (!deleted) {
                    return false;
                }
                ++n2;
            }
        }
        return f.delete();
    }
}

