package org.eclipse.stp.sc.common.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.stp.common.logging.LoggingProxy;

public class LaunchUtil {
	private static final LoggingProxy LOG = LoggingProxy.getlogger(LaunchUtil.class);
	
	public static void launchJavaProgram(IJavaProject javaProject, String mainClass, String[] vmArgs, String[] prgArgs, String[] clsPath)
	throws CoreException{
        IVMInstall vmInstall = JavaRuntime.getVMInstall(javaProject);
        if (vmInstall == null)
           vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall != null) {
           IVMRunner vmRunner = vmInstall.getVMRunner(ILaunchManager.RUN_MODE);
           if (vmRunner != null) {

        	   //get project default class path
        	  String[] prjDefaultClsPath = null; 
              try {
            	  prjDefaultClsPath = JavaRuntime.computeDefaultRuntimeClassPath(javaProject);
              } catch (CoreException e) {
            	  prjDefaultClsPath = null;
              }
              
              String[] newClassPath = combinStringArray(prjDefaultClsPath, clsPath);
              if (newClassPath != null) {
                 VMRunnerConfiguration vmConfig = 
                    new VMRunnerConfiguration(mainClass, newClassPath);
                 if(vmArgs != null && vmArgs.length > 0){
                	 vmConfig.setVMArguments(vmArgs);
                 }
                 if(prgArgs != null && prgArgs.length > 0){
                	 vmConfig.setProgramArguments(prgArgs);
                 }

                 ILaunch launch = new Launch(null, ILaunchManager.RUN_MODE, null);
                 vmRunner.run(vmConfig, launch, null);
                 
                 //wait for launch process done
                 while(!launch.isTerminated()){
                	 try{
                		 Thread.sleep(100);
                	 }catch (InterruptedException ex){
                		 LOG.error(ex);
                	 }
                 }
                 
                 //log errors if any
                 IProcess[] processes = launch.getProcesses();
                 String errMsg = processes[0].getStreamsProxy().getErrorStreamMonitor().getContents();
                 if(errMsg != null && errMsg.length() > 0){
                     LOG.info(errMsg);
                 }
              }
           }
        }
	}
	
	public static String[] combinStringArray(String[] arg0, String[] arg1){
		String[] returnValue = null;
		int size = 0;
		if(arg0 != null){
			size = arg0.length;
		}
		if(arg1 != null){
			size = size + arg1.length; 
		}
		if(size > 0){
			returnValue = new String[size];
			if(arg0 != null){
				System.arraycopy(arg0, 0, returnValue, 0, arg0.length);
			}
			if(arg1 != null){
				System.arraycopy(arg1, 0, returnValue, size - arg1.length, arg1.length);
			}
		}
		return returnValue;
	}
}
