/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractFieldEditor extends Dialog implements TextFieldEditor {

    protected AbstractFieldEditor() {
        this(null);
    }
    
    /**
     * protected contructor meant for subclasses
     */
    protected AbstractFieldEditor(Shell shell) {
        super(shell);
    }
    
    public String getNewValue(String oldVal) {
        String newText = null;
        create();
        setFieldText(oldVal);
        open();
        if (getReturnCode() == Dialog.OK) {
            newText = getFieldText();
        }
        return newText;
    }

}
