/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;


import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.xef.XMLSnippet;

class SelectionCategory {
    private final String name;
    private final SortedSet<Object> entries = new TreeSet<Object>(new Comparator<Object>() {
		public int compare(Object o1, Object o2) {
			if (o1 instanceof SchemaElement && o2 instanceof SchemaElement) {
				return ((SchemaElement) o1).getName().toLowerCase().compareTo(((SchemaElement) o2).getName().toLowerCase());
			}
			
			if (o1 instanceof XMLSnippet && o2 instanceof XMLSnippet) {
				return ((XMLSnippet) o1).getName().toLowerCase().compareTo(((XMLSnippet) o2).getName().toLowerCase());
			}
			
			return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
		}    
    });
    
    SelectionCategory(String n) {
        name = n;
    }

    void addEntry(Object p) {
        entries.add(p);        
    }
    
    public SortedSet<Object> getEntries() {
	return entries;
    }
    
    public String getName() {
	return name;
    }

    @Override
    public String toString() {
        return name;
    }
}
