/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef;

public class ValidationProblem {
    final Object problemObject;
    final String message;
    final XMLInstanceElement instance;
    
    ValidationProblem(Object obj, String msg, XMLInstanceElement inst) {
        problemObject = obj;
        message = msg;
        instance = inst;
    }

    public String getMessage() {
        return message;
    }

    public Object getProblemObject() {
        return problemObject;
    }
    
    public XMLInstanceElement getXMLInstanceElement() {
        return instance;
    }
}
