/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

/**
 * All plugin should extend this class for resoruces accessing
 * refer runtime plugin for example.
 */

public class AbstractResources {
    private static final Logger LOG = Logger.getLogger(AbstractResources.class.getName());
    
    private static final String IMAGE_FOLDER_RELATIVE_PATH = "icons/";

    
    protected AbstractResources() {
        // this is a base utility class, no public constructor allowed
    }

    public static final String getString(ResourceBundle bundle, String key) {
        try {
            return (bundle != null) 
                ? bundle.getString(key)
                : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }
    
    public static final String[] getStringArray(ResourceBundle bundle, String key) {
        Collection<String> values = new ArrayList<String>();
        String value = getString(bundle, key);
        if (value != null && !value.equals("") && !value.equals(key)) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token != null && !token.equals("")) {
                    values.add(token);
                }
            }
        }
        return (String[]) values.toArray(new String[0]);
    }

    /**
     * Uses MessageFormat to build string.
     *
     * @param bundle The resource bundle to search
     * @param strKey The bundle key of MessageFormat string
     * @param strConcatValues a comma separated list of values to concatenate in the order
     * as specified by the messafe format string
     * @param fValuesIsKey if true then strConcatValues is a ResourceBundle key, else
     * strConcatValues is the actual concatenation string
     *
     * @return The translated string
     */
    public static final String getFromMsgFormat(ResourceBundle bundle,
            String strKey, String strConcatValues, boolean fValuesIsKey) {
        String strMsg = getString(bundle, strKey);

        String strConcat = null;

        if (fValuesIsKey) {
            strConcat = getString(bundle, strConcatValues);
        } else {
            strConcat = strConcatValues;
        }

        Object[] aObj = null;
        if (null != strConcat) {
            StringTokenizer st = new StringTokenizer(strConcat, ",");
            aObj = new Object[ st.countTokens() ];

            int x = -1;
            while (st.hasMoreTokens()) {
                aObj[ ++x ] = st.nextToken();
            }
        }

        if (null != aObj && aObj.length > 0) {
            return MessageFormat.format(strMsg, aObj);
        }

        return strMsg;
    }

    public static final ImageDescriptor getImageDescriptor(Bundle bundle, String imageName) {
        URL url = getImageUrl(bundle, imageName);
        return url != null 
            ? ImageDescriptor.createFromURL(url) 
            : ImageDescriptor.getMissingImageDescriptor();
    }
        
    public static final URL getImageUrl(Bundle bundle, String imageName) {
        if (bundle == null) {
            return null;
        }
        
        try {
            URL baseURL = bundle.getEntry("/");
            return new URL(baseURL, IMAGE_FOLDER_RELATIVE_PATH + imageName);
        } catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "image URL invalid (image probably missing)", e);
            return null;
        }        
    }

}
