/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;


public class XefPlugin extends AbstractUIPlugin {
	public static final String ID = "org.eclipse.stp.xef";
	
    public static final String IMG_HORIZONTAL = "horizontal";
    public static final String IMG_VERTICAL = "vertical";    
    public static final String IMG_HORIZONTAL_TB = "horizontal_tb";
    public static final String IMG_VERTICAL_TB = "vertical_tb";
    public static final String IMG_AUTOMATIC_TB = "automatic_tb";
    public static final String IMG_SINGLE_TB = "single_tb";
    
    public static final String IMG_DEFAULT = "default";
    public static final String IMG_DEFAULT_OFF = "default_off";
    public static final String IMG_HELP = "help";
    public static final String IMG_REFRESH = "refresh";
    
    public static final String IMG_INSTANCE = "xef_instance";
    public static final String IMG_INSTANCE_GREY = "xef_instance_grey";
    public static final String IMG_EDIT = "xef_edit";
    public static final String IMG_INSTANCE_PLUS = "xef_instance_plus";
    public static final String IMG_SNIPPET = "xef_snippet";
    public static final String IMG_SNIPPET_GREY = "xef_snippet_grey";
    public static final String IMG_GROUP = "xef_group";
    public static final String IMG_SUB_ELEMENT = "xef_subelement";
    public static final String IMG_SUB_ELEMENT_PLUS = "xef_subelement_plus";
    private static XefPlugin plugin;

    public XefPlugin() {
        plugin = this;
    }

    public static XefPlugin getDefault() {
        return plugin;
    }

    @Override
    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        
        registerImage(reg, IMG_HORIZONTAL, "MDhorizontal.gif"); 
        registerImage(reg, IMG_VERTICAL, "MDvertical.gif"); 
        registerImage(reg, IMG_HORIZONTAL_TB, "th_horizontal.gif");
        registerImage(reg, IMG_VERTICAL_TB, "th_vertical.gif");
        registerImage(reg, IMG_AUTOMATIC_TB, "th_automatic.gif");
        registerImage(reg, IMG_SINGLE_TB, "th_single.gif");
        registerImage(reg, IMG_DEFAULT, "default.gif");
        registerImage(reg, IMG_DEFAULT_OFF, "default_off.gif");
        registerImage(reg, IMG_HELP, "help.gif");
        registerImage(reg, IMG_REFRESH, "refresh.gif");
        registerImage(reg, IMG_INSTANCE, "xef_instance.gif");
        registerImage(reg, IMG_INSTANCE_GREY, "xef_instance_grey.gif");
        registerImage(reg, IMG_EDIT, "xef_edit.gif");
        registerImage(reg, IMG_SNIPPET, "xef_snippet.gif");
        registerImage(reg, IMG_SNIPPET_GREY, "xef_snippet_grey.gif");
        registerImage(reg, IMG_INSTANCE_PLUS, "xef_instance_plus.gif");
        registerImage(reg, IMG_GROUP, "xef_group.gif");
        registerImage(reg, IMG_SUB_ELEMENT, "xef_subelement.gif");
        registerImage(reg, IMG_SUB_ELEMENT_PLUS, "xef_subelement_plus.gif");
    }

    private void registerImage(ImageRegistry registry, String key,
            String fileName) {
        try {
            IPath path = new Path("icons/" + fileName); 
            URL url = FileLocator.find(getBundle(), path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL(url);
                registry.put(key, desc);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SchemaRegistry getSchemaRegistry() {
        return SchemaRegistry.getDefault();
    }

}
