/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;


import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.xef.XMLInstanceElement;

public class AddElementAction extends Action {
	private final XefEditMasterDetailsBlock block;
    private final XMLInstanceElement element;
    private final SchemaElement schemaElement;
    private final TreeViewer viewer;
    
    AddElementAction(String text, XMLInstanceElement pei, SchemaElement se, TreeViewer v, XefEditMasterDetailsBlock b) {
        super(text);
        element = pei;
        schemaElement = se;
        viewer = v;
        block = b;
    }

    @Override
    public void run() {
        XMLInstanceElement child = new XMLInstanceElement(schemaElement, element);
        element.addChild(child, true);
        child.addMinimalSubElements();
        
        viewer.refresh(element);
        viewer.expandToLevel(child, TreeViewer.ALL_LEVELS);
        viewer.setSelection(new StructuredSelection(child), true);
        
        block.setDirty(true);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return XefPlugin.getDefault().getImageRegistry().getDescriptor(
                XefPlugin.IMG_SUB_ELEMENT);                                        
    }
}
