/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSConstants;
import org.apache.xerces.xs.XSSimpleTypeDefinition;

public class SchemaValue {    
    private final XSSimpleTypeDefinition ctx;
    private List<String> allowedValues;

    SchemaValue(XSSimpleTypeDefinition typeDefinition) {
        ctx = typeDefinition;
    }

    public ValueType getType() {
        switch (ctx.getBuiltInKind()) {
        case XSConstants.STRING_DT: 
            StringList enumeration = ctx.getLexicalEnumeration();
            if (enumeration.getLength() > 0) {
                readAllowedValues(enumeration);
                return ValueType.ENUMERATION;
            } else {
                return ValueType.STRING;
            }
        case XSConstants.DECIMAL_DT:
        case XSConstants.FLOAT_DT:
        case XSConstants.DOUBLE_DT:
            return ValueType.FLOATING_POINT;
        case XSConstants.INTEGER_DT:		
        case XSConstants.INT_DT:
            return ValueType.INTEGER;
        case XSConstants.LONG_DT:
		return ValueType.LONG;
        case XSConstants.SHORT_DT:
            return ValueType.SHORT;		
        case XSConstants.BYTE_DT:
            return ValueType.BYTE;		
        case XSConstants.UNSIGNEDLONG_DT:
            return ValueType.ULONG;		
        case XSConstants.UNSIGNEDINT_DT:
            return ValueType.UINT;		
        case XSConstants.UNSIGNEDSHORT_DT:
            return ValueType.USHORT;		
        case XSConstants.UNSIGNEDBYTE_DT:
            return ValueType.UBYTE;
        case XSConstants.NEGATIVEINTEGER_DT:
            return ValueType.NEGATIVE_INT;		
        case XSConstants.POSITIVEINTEGER_DT:
            return ValueType.POSITIVE_INT;		
        case XSConstants.NONNEGATIVEINTEGER_DT:
            return ValueType.NON_NEGATIVE_INT;		
        case XSConstants.NONPOSITIVEINTEGER_DT:
            return ValueType.NON_POSITIVE_INT;
        case XSConstants.BOOLEAN_DT:
            return ValueType.BOOLEAN;
        case XSConstants.NCNAME_DT:
            return ValueType.NCNAME;
        case XSConstants.QNAME_DT:
            return ValueType.QNAME;
        default:
            return ValueType.STRING;
        } 
    }

    private synchronized void readAllowedValues(StringList enumeration) {
        allowedValues = new ArrayList<String>(enumeration.getLength());
        for (int i = 0; i < enumeration.getLength(); i++) {
            allowedValues.add(enumeration.item(i));
        }
        if (allowedValues.size() == 0) {
            allowedValues = null;
        } else {
            allowedValues = Collections.unmodifiableList(allowedValues);
        }
    }
    
    public List<String> getAllowedValues() {
        if (allowedValues == null) {
            readAllowedValues(ctx.getLexicalEnumeration());
        }
        return allowedValues;
    }
}
